/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.sourcerelease.mojos;

import com.atlassian.maven.plugins.sourcerelease.configurations.RepositoryMapping;
import com.atlassian.maven.plugins.sourcerelease.configurations.SourceDependency;
import com.atlassian.maven.plugins.sourcerelease.util.SCMPathType;
import com.atlassian.maven.plugins.sourcerelease.util.filters.OrArtifactFilter;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.InvalidProjectModelException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.settings.Settings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSourceDistributionMojo
extends AbstractMojo {
    protected File outputDirectory;
    protected boolean generatePom;
    protected String groupId;
    protected String artifactId;
    protected String version;
    protected String productName;
    protected String checkoutDirectoryName;
    protected String groupIdMask;
    protected List exclusions;
    protected boolean skip;
    protected boolean resolveRoot;
    protected SourceDependency[] sourceDependencies;
    protected RepositoryMapping[] repositoryMappings;
    protected boolean useReactor;
    protected MavenProject project;
    protected ArtifactFactory artifactFactory;
    protected List<MavenProject> reactorProjects;
    protected MavenProjectBuilder projectBuilder;
    protected ArtifactResolver resolver;
    protected Settings settings;
    protected ArtifactRepository localRepository;
    protected List remoteRepositories;
    protected ArtifactMetadataSource metadataSource;

    protected Set<MavenProject> getResolvedProjects() throws MojoExecutionException {
        Set<MavenProject> projects = this.useReactor ? this.getProjectsForArtifacts(this.getReactorProjectDependencies()) : this.getProjectsForArtifacts(this.getProjectDependencies());
        if (projects == null) {
            throw new MojoExecutionException("Could not resolve dependent projects");
        }
        if (this.useReactor) {
            this.removeReactorProjects(projects);
        }
        this.removeExcludedArtifacts(projects);
        Set<MavenProject> resolvedProjects = this.processProjects(projects);
        if (this.reactorProjects == null || this.reactorProjects.size() < 1) {
            throw new MojoExecutionException("There are no dependent projects left to process.");
        }
        return resolvedProjects;
    }

    private Set<Artifact> getProjectDependencies() throws MojoExecutionException {
        HashSet dependencies = new HashSet();
        try {
            Set artifacts = this.project.createArtifacts(this.artifactFactory, null, null);
            dependencies.addAll(artifacts);
        }
        catch (InvalidDependencyVersionException e) {
            throw new RuntimeException(e);
        }
        OrArtifactFilter dependencyFilter = new OrArtifactFilter();
        dependencyFilter.add((ArtifactFilter)new ScopeArtifactFilter("compile"));
        dependencyFilter.add((ArtifactFilter)new ScopeArtifactFilter("runtime"));
        return this.resolveTransitiveArtifacts(dependencies, dependencyFilter);
    }

    private Set<MavenProject> processProjects(Set<MavenProject> projects) {
        HashSet<MavenProject> resolvedList = new HashSet<MavenProject>();
        HashSet<String> seenSCMUrls = new HashSet<String>();
        for (MavenProject mavenProject : projects) {
            Scm scm;
            MavenProject projectWithRepositoryMappingsApplied = this.findAndApplyRepositoryMappingConfig(mavenProject);
            MavenProject projectWithSourceDepConfigApplied = this.findAndApplySourceDepConfig(projectWithRepositoryMappingsApplied);
            if (projectWithSourceDepConfigApplied == null || (scm = projectWithSourceDepConfigApplied.getScm()) == null || scm.getConnection() == null || seenSCMUrls.contains(scm.getConnection())) continue;
            this.getLog().debug((CharSequence)("Scm is " + scm.getConnection()));
            resolvedList.add(projectWithSourceDepConfigApplied);
            seenSCMUrls.add(scm.getConnection());
        }
        return resolvedList;
    }

    private MavenProject findAndApplyRepositoryMappingConfig(MavenProject mavenProject) {
        if (this.repositoryMappings != null) {
            for (RepositoryMapping config : this.repositoryMappings) {
                Map<String, String> moduleMappings = config.getModuleMapping();
                List<String> repositoryModules = config.getRepositoryModules();
                if (!moduleMappings.containsKey(mavenProject.getArtifactId()) && !repositoryModules.contains(mavenProject.getArtifactId())) continue;
                return this.applyRepositoryMappingConfig(config, mavenProject);
            }
        }
        return mavenProject;
    }

    private MavenProject applyRepositoryMappingConfig(RepositoryMapping config, MavenProject mavenProject) {
        MavenProject processedMavenProject = mavenProject;
        if (config.isResolveRoot()) {
            processedMavenProject = this.resolveRootProject(mavenProject);
        }
        if (config.getBaseRepository() != null && !config.getBaseRepository().equals("")) {
            this.modifyBaseRepository(config.getBaseRepository(), processedMavenProject);
        }
        if (config.getModuleMapping() != null && config.getModuleMapping().size() > 0) {
            this.applyModuleMapping(config.getModuleMapping(), processedMavenProject);
        }
        return processedMavenProject;
    }

    protected MavenProject resolveRootProject(MavenProject mavenProject) {
        this.getLog().debug((CharSequence)("Resolving root project for project" + mavenProject.getArtifactId()));
        String connection = mavenProject.getScm().getConnection();
        SCMPathType scmPathType = SCMPathType.determinePathType(connection);
        MavenProject parentProject = mavenProject;
        if (scmPathType.equals((Object)SCMPathType.UNKNOWN)) {
            this.getLog().warn((CharSequence)MessageFormat.format("Unable to find trunk or tag markers on scm path during root project resolution for {0}, original scm information was {1}", mavenProject.getArtifactId(), connection));
        } else {
            List<String> pathElements = SCMPathType.determinePathElements(connection, scmPathType);
            for (String pathElement : pathElements) {
                parentProject = parentProject.getParent();
            }
        }
        if (!mavenProject.getArtifactId().equals(parentProject.getArtifactId())) {
            this.getLog().info((CharSequence)MessageFormat.format("Resolved root project for {0} to {1}", mavenProject.getArtifactId(), parentProject.getArtifactId()));
        }
        return parentProject;
    }

    private MavenProject findAndApplySourceDepConfig(MavenProject mavenProject) {
        if (this.sourceDependencies != null) {
            for (SourceDependency config : this.sourceDependencies) {
                if (!config.getArtifactId().equals(mavenProject.getArtifactId())) continue;
                return this.applySourceDepConfig(config, mavenProject);
            }
        }
        MavenProject rootProject = this.resolveRoot ? this.resolveRootProject(mavenProject) : mavenProject;
        return rootProject;
    }

    private MavenProject applySourceDepConfig(SourceDependency config, MavenProject mavenProject) {
        MavenProject processedMavenProject = mavenProject;
        if (config.isResolveRoot()) {
            processedMavenProject = this.resolveRootProject(mavenProject);
        }
        if (config.getBaseRepository() != null && !config.getBaseRepository().equals("")) {
            this.modifyBaseRepository(config.getBaseRepository(), processedMavenProject);
        }
        if (config.getModuleMapping() != null && config.getModuleMapping().size() > 0) {
            this.applyModuleMapping(config.getModuleMapping(), processedMavenProject);
        }
        return processedMavenProject;
    }

    protected void applyModuleMapping(Map<String, String> moduleMapping, MavenProject mavenProject) {
        String connection;
        String newConnection = connection = mavenProject.getScm().getConnection();
        for (Map.Entry<String, String> mapping : moduleMapping.entrySet()) {
            newConnection = newConnection.replace("/" + mapping.getKey(), "/" + mapping.getValue());
        }
        this.getLog().info((CharSequence)MessageFormat.format("Module mapping found for {0}, replacing {1} with {2}", mavenProject.getArtifactId(), connection, newConnection));
        mavenProject.getScm().setConnection(newConnection);
    }

    private void modifyBaseRepository(String baseRepository, MavenProject mavenProject) {
        String connection = mavenProject.getScm().getConnection();
        SCMPathType scmPathType = SCMPathType.determinePathType(connection);
        if (scmPathType.equals((Object)SCMPathType.UNKNOWN)) {
            this.getLog().warn((CharSequence)MessageFormat.format("Unable to find trunk or tag markers on scm path during baseRepository replacement for {0}, using project as is", mavenProject.getArtifactId()));
        } else {
            String pathToSubmodule = SCMPathType.getPathToSubModule(connection, scmPathType);
            mavenProject.getScm().setConnection(baseRepository + scmPathType.getMarker().substring(1) + "/" + pathToSubmodule);
        }
    }

    private Set getReactorProjectDependencies() throws MojoExecutionException {
        HashSet dependencies = new HashSet();
        for (MavenProject mavenProject : this.reactorProjects) {
            Set projectDependencies = mavenProject.getDependencyArtifacts();
            if (projectDependencies == null || projectDependencies.isEmpty()) continue;
            dependencies.addAll(projectDependencies);
        }
        return this.resolveTransitiveArtifacts(dependencies);
    }

    private Set<MavenProject> getProjectsForArtifacts(Set<Artifact> artifacts) throws MojoExecutionException {
        HashSet<MavenProject> projects = new HashSet<MavenProject>();
        for (Artifact artifact : artifacts) {
            MavenProject currentProject = this.getProjectForArtifact(artifact);
            if (!artifact.getGroupId().startsWith(this.groupIdMask)) continue;
            projects.add(currentProject);
        }
        return projects;
    }

    private void removeExcludedArtifacts(Set<MavenProject> projects) throws MojoExecutionException {
        List<String> exclusionPairs = this.getExclusions();
        ArrayList<MavenProject> projectList = new ArrayList<MavenProject>(projects);
        for (MavenProject currentProject : projectList) {
            if (currentProject == null) {
                this.getLog().info((CharSequence)"Project in project list is null");
                continue;
            }
            if (!this.matchesExclusion(currentProject, exclusionPairs)) continue;
            projects.remove(currentProject);
        }
    }

    private void removeReactorProjects(Set<MavenProject> projects) {
        for (MavenProject project : this.reactorProjects.subList(1, this.reactorProjects.size())) {
            if (!projects.contains(project) || projects.remove(project)) continue;
            this.getLog().warn((CharSequence)("Could not remove reactor project from checkout list for '" + project.getGroupId() + ":" + project.getArtifactId() + "'"));
        }
    }

    private List<String> getExclusions() {
        ArrayList<String> excludes = new ArrayList<String>(this.exclusions);
        List<MavenProject> reactorExclusions = this.reactorProjects.subList(1, this.reactorProjects.size());
        for (MavenProject mavenProject : reactorExclusions) {
            excludes.add(mavenProject.getGroupId() + ":" + mavenProject.getArtifactId());
        }
        return excludes;
    }

    private boolean matchesExclusion(MavenProject project, List<String> exclusionPairs) throws MojoExecutionException {
        for (String exclusion : exclusionPairs) {
            String[] parts = StringUtils.split((String)exclusion, (char)':');
            if (parts.length == 2) {
                String currentGroupId = project.getGroupId();
                String currentArtifactId = project.getArtifactId();
                if (!parts[0].equals(currentGroupId) || !parts[1].equals(currentArtifactId)) continue;
                return true;
            }
            throw new MojoExecutionException("Exclusion is not in the format of groupId:artifactId. Value:" + exclusion);
        }
        return false;
    }

    private Set resolveTransitiveArtifacts(Set artifacts, ArtifactFilter filter) throws MojoExecutionException {
        try {
            ArtifactResolutionResult result = this.resolver.resolveTransitively(artifacts, this.project.getArtifact(), this.localRepository, this.remoteRepositories, this.metadataSource, filter);
            return result.getArtifacts();
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private Set resolveTransitiveArtifacts(Set artifacts) throws MojoExecutionException {
        return this.resolveTransitiveArtifacts(artifacts, null);
    }

    private MavenProject getProjectForArtifact(Artifact artifact) throws MojoExecutionException {
        try {
            return this.projectBuilder.buildFromRepository(artifact, this.remoteRepositories, this.localRepository);
        }
        catch (InvalidProjectModelException e) {
            return null;
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }
}

