package com.atlassian.maven.plugins.sourcerelease.mojos.hg;


import org.apache.maven.scm.CommandParameter;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.export.ExportScmResult;
import org.apache.maven.scm.provider.hg.HgScmProvider;
import org.apache.maven.scm.repository.ScmRepository;

public class HgScmProviderUtils
{

    private HgScmProviderUtils()
    {
    }

    public static ExportScmResult export(final HgScmProvider scmProvider, ScmRepository repository, ScmFileSet fileSet, String outputDirectory) throws ScmException
    {
        return export(scmProvider, repository, fileSet, null, outputDirectory);
    }

    private static ExportScmResult export(final HgScmProvider scmProvider, final ScmRepository repository, final ScmFileSet fileSet, ScmVersion scmVersion, final String outputDirectory) throws ScmException
    {
        CommandParameters parameters = new CommandParameters();
        parameters.setScmVersion(CommandParameter.SCM_VERSION, scmVersion);
        parameters.setString(CommandParameter.OUTPUT_DIRECTORY, outputDirectory);

        return export(scmProvider, repository, fileSet, parameters);
    }

    private static ExportScmResult export(final HgScmProvider scmProvider, final ScmRepository repository, final ScmFileSet fileSet, CommandParameters parameters)
            throws ScmException
    {
        HgExportCommand command = new HgExportCommand();
        
        command.setLogger(scmProvider.getLogger());

        return (ExportScmResult) command.execute(repository.getProviderRepository(), fileSet, parameters);
    }


}
