package com.atlassian.maven.plugins.sourcerelease.mojos;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

import java.util.Set;

/**
 * Goal checkes out dependencies from source control for a given groupId mask
 *
 * @goal list
 *
 */

public class ListMojo extends AbstractSourceDistributionMojo
{
    public void execute() throws MojoExecutionException, MojoFailureException
    {
        if (skip)
        {
            getLog().info("Skipping source distribution execution");
            return;
        }

        final Set<MavenProject> resolvedProjects = getResolvedProjects();


        getLog().info("Will checkout the following artifacts:");
        for (MavenProject currentProject : resolvedProjects)
        {
            getLog().info(currentProject.getGroupId() + ":" + currentProject.getArtifactId() + " at " + currentProject.getScm().getConnection());
        }
        
        MavenProject rootProject = reactorProjects.get(0);
        if (rootProject.getScm() != null && rootProject.getScm().getConnection() != null)
        {
            getLog().info(rootProject.getGroupId() + ":" + rootProject.getArtifactId() + " at " + rootProject.getScm().getConnection());
        }
        else
        {
            getLog().warn("Skipping " + rootProject.getArtifactId() + " as it did not have a valid <scm> tag");            
        }
    }
}
