/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins;

import com.atlassian.maven.plugins.AbstractIdeaMojo;
import java.io.File;
import java.util.Iterator;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.dom4j.Document;
import org.dom4j.Element;

public class Test
extends AbstractIdeaMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.doDependencyResolution(this.executedProject, this.localRepo);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to build project dependencies.", e);
        }
        this.build();
    }

    public void build() throws MojoExecutionException {
        this.initAtlassianVariables();
        if (this.executedProject.getArtifactId().equals("confluence")) {
            this.modifyTestEnvModule("../");
        } else if (this.executedProject.getArtifactId().equals("jira-core")) {
            this.modifyTestEnvModule("../");
        }
    }

    protected void modifyTestEnvModule(String relPath) throws MojoExecutionException {
        String imlFile = "test_env.iml";
        this.getLog().info((CharSequence)"Creating Test Module Environment...");
        File dir = new File(this.executedProject.getBasedir(), relPath + "modules/test_env");
        dir.mkdirs();
        File moduleFile = new File(dir, imlFile);
        String resourceName = "test_env-module.xml";
        Document document = this.readXmlDocument(resourceName);
        Element module = document.getRootElement();
        this.replaceJavaVersion(module, moduleFile);
        this.replaceArtifactId(module);
        Element component = this.findElement(module, "component", "NewModuleRootManager");
        Element classesChild = this.findElement(component, "orderEntry", "type", "module-library").element("library").element("CLASSES");
        this.removeOldElements(classesChild, "root");
        Iterator i = this.executedProject.getBuild().getTestResources().iterator();
        while (i.hasNext()) {
            Resource resource = (Resource)i.next();
            String directory = resource.getDirectory();
            if (resource.getTargetPath() != null || resource.isFiltering()) continue;
            String relativeDir = "file://" + this.invertSlashes(directory);
            this.findElement(classesChild, "root", "url", relativeDir);
        }
        this.writeXmlDocument(moduleFile, document);
    }
}

