/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins;

import com.atlassian.maven.plugins.AbstractIdeaMojo;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.dom4j.Document;
import org.dom4j.Element;

public class Resin3
extends AbstractIdeaMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.doDependencyResolution(this.executedProject, this.localRepo);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to build project dependencies.", e);
        }
        this.build();
    }

    public void build() throws MojoExecutionException {
        String resin3Location;
        this.initAtlassianVariables();
        if (this.executedProject.isExecutionRoot() && (resin3Location = this.atlassianProperties.getProperty("atlassian.idea.resin3.location")) != null) {
            File resin3 = new File(resin3Location + "/lib/resin.jar");
            File resin_env = new File(this.executedProject.getBasedir(), "/modules/resin3_env");
            if (resin3.exists()) {
                this.modifyIpr("$PROJECT_DIR$/modules/resin3_env/resin3_env.iml");
                this.modifyIws();
                this.modifyResinEnvModule(resin_env, true);
                this.generateResin3XML();
            } else {
                this.getLog().error((CharSequence)("Unable to find resin3 jar in " + resin3.getAbsolutePath()));
            }
        }
    }

    private void modifyIws() throws MojoExecutionException {
        File workspaceFile = new File(this.executedProject.getBasedir(), this.executedProject.getArtifactId() + ".iws");
        Document document = this.readXmlDocument(workspaceFile);
        Element module = document.getRootElement();
        Element runManager = this.findComponent(module, "RunManager");
        Element conf = this.findElement(runManager, "configuration", "Resin 3").addAttribute("type", "Application").addAttribute("default", "false").addAttribute("selected", "false");
        String mainClassName = "com.caucho.server.resin.Resin";
        String vmParameters = "-Dresin.home=resin3 -Djava.util.logging.manager=com.caucho.log.LogManagerImpl " + this.appParams;
        String programParameters = "-conf resin.conf";
        String workingDirectory = "$PROJECT_DIR$";
        String moduleName = "resin3_env";
        this.createOptions(conf, mainClassName, vmParameters, programParameters, workingDirectory, moduleName);
        this.writeXmlDocument(workspaceFile, document);
    }

    private void generateResin3XML() throws MojoExecutionException {
        File dir = new File(this.executedProject.getBasedir().getPath() + "/resin3");
        dir.mkdirs();
        Document resinConfFile = null;
        File targetFile = this.createResin3XMLFile(resinConfFile, dir);
        this.replaceVars(targetFile);
        this.createAppDefaultXMLFile(dir);
    }

    private void createAppDefaultXMLFile(File dir) throws MojoExecutionException {
        Document appdefaultDoc = null;
        appdefaultDoc = this.readXmlDocument("resin.3.app-default.xml");
        this.writeXmlDocument(new File(dir, "app-default.xml"), appdefaultDoc);
    }

    private void replaceVars(File targetFile) throws MojoExecutionException {
        this.replace(targetFile, "\\$\\{atlassian.idea.application.webapp.contextpath\\}", this.invertSlashes(this.atlassianProperties.getProperty("atlassian.idea.application.webapp.contextpath")));
        this.replace(targetFile, "\\$\\{basedir\\}", this.invertSlashes(this.executedProject.getBasedir().getPath()));
        this.replace(targetFile, "\\$\\{maven.war.src\\}", this.invertSlashes(this.atlassianProperties.getProperty("maven.war.src")));
        this.replace(targetFile, "\\$\\{resin.workdir\\}", this.invertSlashes(this.atlassianProperties.getProperty("resin.workdir")));
        this.replace(targetFile, "\\$\\{resin.tempdir\\}", this.invertSlashes(this.atlassianProperties.getProperty("resin.tempdir")));
        this.replace(targetFile, "\\$\\{atlassian.idea.application.port\\}", this.invertSlashes(this.appPort));
        this.replace(targetFile, "\\$\\{atlassian.idea.application.db.jndiname\\}", this.invertSlashes(this.atlassianProperties.getProperty("atlassian.idea.application.db.jndiname")));
        this.replace(targetFile, "\\$\\{atlassian.idea.application.db.drivername\\}", this.invertSlashes(this.atlassianProperties.getProperty("atlassian.idea.application.db.drivername")));
        this.replace(targetFile, "\\$\\{atlassian.idea.application.db.url\\}", this.invertSlashes(this.atlassianProperties.getProperty("atlassian.idea.application.db.url")));
        this.replace(targetFile, "\\$\\{atlassian.idea.application.db.username\\}", this.invertSlashes(this.atlassianProperties.getProperty("atlassian.idea.application.db.username")));
        this.replace(targetFile, "\\$\\{atlassian.idea.application.db.password\\}", this.invertSlashes(this.atlassianProperties.getProperty("atlassian.idea.application.db.password")));
    }

    private File createResin3XMLFile(Document resinConfFile, File dir) throws MojoExecutionException {
        resinConfFile = this.atlassianProperties.getProperty("atlassian.idea.application.db.jndiname") != null ? this.readXmlDocument("resin3.resin.conf") : this.readXmlDocument("resin3.resin.conf.without.datasource");
        File targetFile = new File(dir, "resin.conf");
        try {
            this.writeXmlDocument(targetFile, resinConfFile);
        }
        catch (MojoExecutionException e) {
            e.printStackTrace();
        }
        return targetFile;
    }
}

