/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins;

import com.atlassian.maven.plugins.AbstractIdeaMojo;
import java.io.File;
import java.util.Hashtable;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.dom4j.Document;
import org.dom4j.Element;

public class Resin
extends AbstractIdeaMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.doDependencyResolution(this.executedProject, this.localRepo);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to build project dependencies.", e);
        }
        this.build();
    }

    public void build() throws MojoExecutionException {
        String resinLocation;
        this.initAtlassianVariables();
        if (this.executedProject.isExecutionRoot() && (resinLocation = this.atlassianProperties.getProperty("atlassian.idea.resin.location")) != null) {
            File resin = new File(resinLocation + "/lib/resin.jar");
            File resin_env = new File(this.executedProject.getBasedir(), "/modules/resin_env");
            if (resin.exists()) {
                this.modifyIpr("$PROJECT_DIR$/modules/resin_env/resin_env.iml");
                this.modifyIws();
                this.modifyResinEnvModule(resin_env, false);
                this.createResinXml();
            } else {
                this.getLog().error((CharSequence)("Unable to find resin jar in " + resin.getAbsolutePath()));
            }
        }
    }

    private void modifyIws() throws MojoExecutionException {
        File workspaceFile = new File(this.executedProject.getBasedir(), this.executedProject.getArtifactId() + ".iws");
        Document document = this.readXmlDocument(workspaceFile);
        Element module = document.getRootElement();
        Element runManager = this.findComponent(module, "RunManager");
        Element conf = this.findElement(runManager, "configuration", "Resin").addAttribute("type", "Application").addAttribute("default", "false").addAttribute("selected", "true");
        String mainClassName = "com.caucho.server.http.HttpServer";
        String vmParameters = "-Dresin.home=resin " + this.appParams;
        String programParameters = "-conf resin.xml";
        String workingDirectory = "$PROJECT_DIR$";
        String moduleName = "resin_env";
        this.createOptions(conf, mainClassName, vmParameters, programParameters, workingDirectory, moduleName);
        this.writeXmlDocument(workspaceFile, document);
    }

    private void createResinXml() throws MojoExecutionException {
        File baseDir = this.executedProject.getBasedir();
        File resinDir = new File(baseDir, "/resin/");
        resinDir.mkdirs();
        String resourceName = "resin.xml";
        File resinXml = new File(resinDir, "/resin.xml");
        Document document = this.readXmlDocument(resourceName);
        Element root = document.getRootElement();
        this.configDefaultCompiler(root);
        root.element("log").addAttribute("id", baseDir.getAbsolutePath() + "/resin/logs/stdout.log");
        root.element("http-server").element("http").addAttribute("port", this.appPort);
        root.element("http-server").element("host").element("error-log").addAttribute("id", baseDir.getAbsolutePath() + "/resin/logs/error.log");
        String contextPath = this.atlassianProperties.getProperty("atlassian.idea.application.webapp.contextpath");
        contextPath = contextPath == null ? "" : contextPath;
        String mavenWarSrc = this.atlassianProperties.getProperty("maven.war.src");
        if (mavenWarSrc == null) {
            throw new MojoExecutionException("maven.war.src variable not set\nPlease set maven.war.src variable your webapp directory (relative to the project root)");
        }
        root.element("http-server").element("host").element("web-app").addAttribute("id", "/" + contextPath).addAttribute("app-dir", mavenWarSrc);
        root.element("http-server").element("host").element("web-app").element("work-dir").setText(baseDir.getAbsolutePath() + "/resin/work");
        root.element("http-server").element("host").element("web-app").element("temp-dir").setText(baseDir.getAbsolutePath() + "/resin/tmp");
        this.resourceRef(root);
        this.writeXmlDocument(resinXml, document);
    }

    private void resourceRef(Element root) {
        if (((Hashtable)this.atlassianProperties).containsKey("atlassian.idea.application.db.jndiname")) {
            Element resource = this.findElement(root, "resource-ref");
            this.findElement(resource, "res-type").setText("javax.sql.DataSource");
            this.findElement(resource, "init-param", "max-connections", "20");
            this.findElement(resource, "init-param", "max-idle-time", "30");
            String jndiName = this.atlassianProperties.getProperty("atlassian.idea.application.db.jndiname");
            String driverName = this.atlassianProperties.getProperty("atlassian.idea.application.db.drivername");
            String url = this.atlassianProperties.getProperty("atlassian.idea.application.db.url");
            String username = this.atlassianProperties.getProperty("atlassian.idea.application.db.username");
            String password = this.atlassianProperties.getProperty("atlassian.idea.application.db.password");
            this.findElement(resource, "res-ref-name").setText(jndiName);
            this.findElementWithAttribute(resource, "init-param", "driver-name").addAttribute("driver-name", driverName);
            this.findElementWithAttribute(resource, "init-param", "url").addAttribute("url", url);
            this.findElementWithAttribute(resource, "init-param", "user").addAttribute("user", username);
            this.findElementWithAttribute(resource, "init-param", "password").addAttribute("password", password);
        }
    }

    private void configDefaultCompiler(Element module) {
        String jikesPath;
        File jikes;
        Element option = this.findElement(module, "java").addAttribute("compiler-args", "");
        if (((Hashtable)this.atlassianProperties).containsKey("atlassian.idea.jikespath") && (jikes = new File(jikesPath = this.atlassianProperties.getProperty("atlassian.idea.jikespath"))).exists()) {
            option.addAttribute("compiler", jikesPath);
            return;
        }
        option.addAttribute("compiler", "jikes");
    }
}

