/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins;

import com.atlassian.maven.plugins.AbstractIdeaMojo;
import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class IdeaWorkspaceMojo
extends AbstractIdeaMojo {
    private Properties atlassianProperties;

    public void execute() throws MojoExecutionException {
        try {
            this.doDependencyResolution(this.executedProject, this.localRepo);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to build project dependencies.", e);
        }
        this.rewriteWorkspace();
    }

    public void rewriteWorkspace() throws MojoExecutionException {
        File workspaceFile = new File(this.executedProject.getBasedir(), this.executedProject.getArtifactId() + ".iws");
        this.atlassianProperties = this.executedProject.getProperties();
        Document document = this.readXmlDocument(workspaceFile);
        Element module = document.getRootElement();
        this.addAtlassianConfig(module);
        this.addAtlassianDefaultModule(module);
        this.writeXmlDocument(workspaceFile, document);
    }

    private void addAtlassianConfig(Element module) {
        Element runManager = this.findComponent(module, "RunManager");
        String appParams = this.atlassianProperties.getProperty("atlassian.idea.application.params");
        InputStream data = ((Object)((Object)this)).getClass().getResourceAsStream("/default/workspace.xml");
        try {
            Document atlassianConfig = new SAXReader().read(data);
            Element root = atlassianConfig.getRootElement();
            Iterator iterator = root.elementIterator();
            while (iterator.hasNext()) {
                Element child = (Element)iterator.next();
                Element newChild = child.createCopy();
                String name = newChild.attributeValue("name");
                this.removeElement(runManager, "configuration", name);
                runManager.add(newChild);
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
    }

    private void addAtlassianDefaultModule(Element root) {
        Element runManager = this.findComponent(root, "RunManager");
        Element config = this.findElement(runManager, "configuration", "factoryName", "Application");
        Element module = config.element("module");
        if (module != null && module.attributeValue("name").equals("") && this.executedProject.getArtifactId().indexOf("confluence") > -1) {
            module.addAttribute("name", "confluence");
        }
    }
}

