package com.atlassian.maven.plugins;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.model.Resource;
import org.dom4j.Document;
import org.dom4j.Element;

import java.io.File;
import java.util.Iterator;

/**
 * @author Atlassian
 * @goal test
 * @execute phase="generate-sources"
 */
public class Test
        extends AbstractIdeaMojo
{

    public void execute() throws MojoExecutionException, MojoFailureException
    {
        try
        {
            doDependencyResolution(executedProject, localRepo);
        }
        catch (Exception e)
        {
            throw new MojoExecutionException("Unable to build project dependencies.", e);
        }


        build();
    }

    public void build()
            throws MojoExecutionException
    {
        initAtlassianVariables();
        if (executedProject.getArtifactId().equals("confluence"))
        {
            modifyTestEnvModule("../");
        }
        else if(executedProject.getArtifactId().equals("jira-core"))
        {
            modifyTestEnvModule("../");
        }
//        else if(executedProject.isExecutionRoot())
//        {
//            modifyTestEnvModule("");
//        }
    }

    protected void modifyTestEnvModule(String relPath) throws MojoExecutionException
    {
        String imlFile = "test_env.iml";


        getLog().info("Creating Test Module Environment...");
        File dir = new File(executedProject.getBasedir(), relPath + "modules/test_env");
        dir.mkdirs();
        File moduleFile = new File(dir, imlFile);
        String resourceName = "test_env-module.xml";

        Document document = readXmlDocument(resourceName);

        Element module = document.getRootElement();
        replaceJavaVersion(module, moduleFile);
        replaceArtifactId(module);

        Element component = findElement(module, "component", "NewModuleRootManager");
        Element classesChild = findElement(component, "orderEntry", "type", "module-library").element("library").element("CLASSES");
        removeOldElements(classesChild, "root");

        /* This section generates the source URL from the test resources in POM*/
        for (Iterator i = executedProject.getBuild().getTestResources().iterator(); i.hasNext();)
        {
            Resource resource = (Resource) i.next();
            String directory = resource.getDirectory();
            if (resource.getTargetPath() == null && !resource.isFiltering())
            {
                String relativeDir = "file://" + invertSlashes(directory);
                findElement(classesChild, "root", "url", relativeDir);
            }
        }
        writeXmlDocument(moduleFile, document);


    }


}
