package com.atlassian.maven.plugins;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

import java.io.File;
import java.io.IOException;

/**
 * Created by IntelliJ IDEA.
 * User: Tony
 * Date: 13/09/2006
 * Time: 16:04:34
 * To change this template use File | Settings | File Templates.
 */

/**
 * @goal resin3
 * @execute phase="generate-sources"
 */
public class Resin3 extends AbstractIdeaMojo
{

    public void execute() throws MojoExecutionException, MojoFailureException
    {
        try
        {
            doDependencyResolution(executedProject, localRepo);
        }
        catch (Exception e)
        {
            throw new MojoExecutionException("Unable to build project dependencies.", e);
        }

        build();
    }

    public void build()
            throws MojoExecutionException
    {
        initAtlassianVariables();

        if (executedProject.isExecutionRoot())
        {
            String resin3Location = atlassianProperties.getProperty("atlassian.idea.resin3.location");
            if (resin3Location != null)
            {
                File resin3 = new File(resin3Location + "/lib/resin.jar");
                File resin_env = new File(executedProject.getBasedir(), "/modules/resin3_env");
                if (resin3.exists())
                {
                    modifyIpr("$PROJECT_DIR$/modules/resin3_env/resin3_env.iml");
                    modifyIws();
                    modifyResinEnvModule(resin_env, true);
                    generateResin3XML();
                } else
                {
                    getLog().error("Unable to find resin3 jar in "+ resin3.getAbsolutePath());
                }
            }
        }
    }

    private void modifyIws()
            throws MojoExecutionException
    {
        File workspaceFile = new File(executedProject.getBasedir(), executedProject.getArtifactId() + ".iws");
        Document document = readXmlDocument(workspaceFile);
        Element module = document.getRootElement();

        /*Add Atlassian Configuration */
        Element runManager = findComponent(module, "RunManager");


        Element conf = findElement(runManager, "configuration", "Resin 3")
                .addAttribute("type", "Application")
                .addAttribute("default", "false")
                .addAttribute("selected", "false");
        String mainClassName = "com.caucho.server.resin.Resin";
        String vmParameters = "-Dresin.home=resin3 -Djava.util.logging.manager=com.caucho.log.LogManagerImpl " + appParams;
        String programParameters = "-conf resin.conf";
        String workingDirectory = "$PROJECT_DIR$";
        String moduleName = "resin3_env";
        createOptions(conf, mainClassName, vmParameters, programParameters, workingDirectory, moduleName);

        writeXmlDocument(workspaceFile, document);

    }

    private void generateResin3XML() throws MojoExecutionException
    {

        //getLog().info("Creating " + executedProject.getBasedir().getPath() + "\\resin3\\resin.conf ...");
        File dir = new File(executedProject.getBasedir().getPath() + "/resin3");
        dir.mkdirs();
        Document resinConfFile = null;

        File targetFile = createResin3XMLFile(resinConfFile, dir);
        replaceVars(targetFile);

        createAppDefaultXMLFile(dir);

    }

    private void createAppDefaultXMLFile(File dir) throws MojoExecutionException
    {
        //getLog().info("Creating " + executedProject.getBasedir().getPath() + "/resin3/app-default.xml ...");

        Document appdefaultDoc = null;

        appdefaultDoc = readXmlDocument("resin.3.app-default.xml");
        writeXmlDocument(new File(dir, "app-default.xml"), appdefaultDoc);
    }

    private void replaceVars(File targetFile) throws MojoExecutionException
    {
        /** TODO: Ugly, can we have a parser of some sort here? **/
        replace(targetFile, "\\$\\{atlassian.idea.application.webapp.contextpath\\}", invertSlashes(atlassianProperties.getProperty("atlassian.idea.application.webapp.contextpath")));
        replace(targetFile, "\\$\\{basedir\\}", invertSlashes(executedProject.getBasedir().getPath()));
        replace(targetFile, "\\$\\{maven.war.src\\}", invertSlashes(atlassianProperties.getProperty("maven.war.src")));
        replace(targetFile, "\\$\\{resin.workdir\\}", invertSlashes(atlassianProperties.getProperty("resin.workdir")));
        replace(targetFile, "\\$\\{resin.tempdir\\}", invertSlashes(atlassianProperties.getProperty("resin.tempdir")));
        replace(targetFile, "\\$\\{atlassian.idea.application.port\\}", invertSlashes(appPort));
        replace(targetFile, "\\$\\{atlassian.idea.application.db.jndiname\\}", invertSlashes(atlassianProperties.getProperty("atlassian.idea.application.db.jndiname")));
        replace(targetFile, "\\$\\{atlassian.idea.application.db.drivername\\}", invertSlashes(atlassianProperties.getProperty("atlassian.idea.application.db.drivername")));
        replace(targetFile, "\\$\\{atlassian.idea.application.db.url\\}", invertSlashes(atlassianProperties.getProperty("atlassian.idea.application.db.url")));
        replace(targetFile, "\\$\\{atlassian.idea.application.db.username\\}", invertSlashes(atlassianProperties.getProperty("atlassian.idea.application.db.username")));
        replace(targetFile, "\\$\\{atlassian.idea.application.db.password\\}", invertSlashes(atlassianProperties.getProperty("atlassian.idea.application.db.password")));
    }

    private File createResin3XMLFile(Document resinConfFile, File dir) throws MojoExecutionException
    {

        if (atlassianProperties.getProperty("atlassian.idea.application.db.jndiname") != null)
        {
            resinConfFile = readXmlDocument("resin3.resin.conf");

        } else
        {
            resinConfFile = readXmlDocument("resin3.resin.conf.without.datasource");
        }


        File targetFile = new File(dir, "resin.conf");

        try
        {
            writeXmlDocument(targetFile, resinConfFile);
        } catch (MojoExecutionException e)
        {
            e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
        }
        /*resinConfFile = new File((getClass().getResource("/default/resin.conf").toString()));
        resinConfFile.get
        replaceTokens();*/

        return targetFile;
    }
}
