/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins;

import com.atlassian.maven.plugins.AbstractIdeaMojo;
import java.io.File;
import java.util.Hashtable;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.dom4j.Document;
import org.dom4j.Element;

public class Tomcat
extends AbstractIdeaMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.doDependencyResolution(this.executedProject, this.localRepo);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to build project dependencies.", e);
        }
        this.build();
    }

    public void build() throws MojoExecutionException {
        String tomcatLocation;
        this.initAtlassianVariables();
        if (this.executedProject.isExecutionRoot() && (tomcatLocation = this.atlassianProperties.getProperty("atlassian.idea.tomcat.location")) != null) {
            File tomcat = new File(tomcatLocation + "/bin/bootstrap.jar");
            if (tomcat.exists()) {
                this.modifyIpr("$PROJECT_DIR$/modules/tomcat_env/tomcat_env.iml");
                this.modifyIws();
                this.generateModulesForApps();
                this.createTomcatXml();
            } else {
                this.getLog().error((CharSequence)("Unable to find tomcat jar in " + tomcat.getAbsolutePath()));
            }
        }
    }

    public void modifyIws() throws MojoExecutionException {
        File workspaceFile = new File(this.executedProject.getBasedir(), this.executedProject.getArtifactId() + ".iws");
        Document document = this.readXmlDocument(workspaceFile);
        Element module = document.getRootElement();
        Element runManager = this.findComponent(module, "RunManager");
        Element conf = this.findElement(runManager, "configuration", "Tomcat").addAttribute("type", "Application").addAttribute("default", "false").addAttribute("selected", "false").addAttribute("factoryName", "Application");
        String mainClassName = "org.apache.catalina.startup.Bootstrap";
        String tomcatLocation = this.atlassianProperties.getProperty("atlassian.idea.tomcat.location");
        String vmParameters = "-Dcatalina.home=\"" + tomcatLocation + "\" -Dcatalina.base=\"tomcat\" -Djava.util.logging.manager=org.apache.juli.ClassLoaderLogManager " + this.appParams;
        String programParameters = "start";
        String workingDirectory = "file://$PROJECT_DIR$";
        String moduleName = "tomcat_env";
        this.createOptions(conf, mainClassName, vmParameters, programParameters, workingDirectory, moduleName);
        this.writeXmlDocument(workspaceFile, document);
    }

    void generateModulesForApps() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Creating Tomcat Environment...");
        File modulePath = new File(this.executedProject.getBasedir(), "/modules/tomcat_env");
        File resourceFile = new File(modulePath, "tomcat_env-module.xml");
        File imlFile = new File(modulePath, "tomcat_env.iml");
        modulePath.mkdirs();
        this.modifyEnvModule("atlassian.idea.tomcat.location", resourceFile, imlFile);
    }

    private void createTomcatXml() {
        File baseDir = this.executedProject.getBasedir();
        File tomcatDir = new File(baseDir, "/tomcat/conf/");
        tomcatDir.mkdirs();
        String resourceName = "tomcat-server.xml";
        try {
            File tomcatServerXml = new File(tomcatDir, "/server.xml");
            Document document = this.readXmlDocument(resourceName);
            Element root = document.getRootElement();
            this.configDefaultCompiler(root);
            root.element("Service").element("Connector").addAttribute("port", this.appPort);
            String contextPath = this.atlassianProperties.getProperty("atlassian.idea.application.webapp.contextpath");
            contextPath = contextPath == null ? "" : "/" + contextPath;
            String mavenWarSrc = this.atlassianProperties.getProperty("maven.war.src");
            Element context = root.element("Service").element("Engine").element("Host").element("Context");
            context.addAttribute("path", contextPath);
            if (mavenWarSrc == null) {
                throw new MojoExecutionException("maven.war.src variable not set\nPlease set maven.war.src variable your webapp directory (relative to the project root)");
            }
            context.addAttribute("docBase", this.executedProject.getBasedir() + "/" + mavenWarSrc);
            this.resourceRef(context);
            this.writeXmlDocument(tomcatServerXml, document);
            document = this.readXmlDocument("tomcat-web.xml");
            File tomcatWebXml = new File(tomcatDir, "/web.xml");
            this.writeXmlDocument(tomcatWebXml, document);
        }
        catch (MojoExecutionException e) {
            e.printStackTrace();
        }
    }

    private void resourceRef(Element root) {
        if (((Hashtable)this.atlassianProperties).containsKey("atlassian.idea.application.db.jndiname")) {
            String jndiName = this.atlassianProperties.getProperty("atlassian.idea.application.db.jndiname");
            String driverName = this.atlassianProperties.getProperty("atlassian.idea.application.db.drivername");
            String url = this.atlassianProperties.getProperty("atlassian.idea.application.db.url");
            String username = this.atlassianProperties.getProperty("atlassian.idea.application.db.username");
            String password = this.atlassianProperties.getProperty("atlassian.idea.application.db.password");
            Element resource = this.findElement(root, "resource-ref", "type", "javax.sql.DataSource").addAttribute("name", jndiName).addAttribute("username", username).addAttribute("password", password).addAttribute("driverClassName", driverName).addAttribute("url", url);
        }
    }

    private void configDefaultCompiler(Element module) {
        String jikesPath;
        File jikes;
        Element option = this.findElement(module, "java").addAttribute("compiler-args", "");
        if (((Hashtable)this.atlassianProperties).containsKey("atlassian.idea.jikespath") && (jikes = new File(jikesPath = this.atlassianProperties.getProperty("atlassian.idea.jikespath"))).exists()) {
            option.addAttribute("compiler", jikesPath);
            return;
        }
        option.addAttribute("compiler", "jikes");
    }
}

