/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins;

import com.atlassian.maven.plugins.AbstractIdeaMojo;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.FileUtils;
import org.dom4j.Document;
import org.dom4j.Element;

public class Orion
extends AbstractIdeaMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.doDependencyResolution(this.executedProject, this.localRepo);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to build project dependencies.", e);
        }
        this.build();
    }

    public void build() throws MojoExecutionException {
        String orionLocation;
        this.initAtlassianVariables();
        if (this.executedProject.isExecutionRoot() && (orionLocation = this.atlassianProperties.getProperty("atlassian.idea.orion.location")) != null) {
            File orion = new File(orionLocation + "/orion.jar");
            if (orion.exists()) {
                this.modifyIpr("$PROJECT_DIR$/modules/orion_env/orion_env.iml");
                this.modifyIws();
                this.generateModulesForApps();
                this.createOrionXml();
            } else {
                this.getLog().error((CharSequence)("Unable to find orion jar in " + orion.getAbsolutePath()));
            }
        }
    }

    public void modifyIws() throws MojoExecutionException {
        File workspaceFile = new File(this.executedProject.getBasedir(), this.executedProject.getArtifactId() + ".iws");
        Document document = this.readXmlDocument(workspaceFile);
        Element module = document.getRootElement();
        Element runManager = this.findComponent(module, "RunManager");
        Element conf = this.findElement(runManager, "configuration", "Orion").addAttribute("type", "Application").addAttribute("default", "false").addAttribute("selected", "false").addAttribute("factoryName", "Application");
        String mainClassName = "com.evermind.server.ApplicationServer";
        String vmParameters = "-Xdebug -Xnoagent -Djava.compiler=NONE -Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=5005 " + this.appParams;
        String programParameters = "-userThreads";
        String workingDirectory = "file://$PROJECT_DIR$/orion";
        String moduleName = "orion_env";
        this.createOptions(conf, mainClassName, vmParameters, programParameters, workingDirectory, moduleName);
        this.writeXmlDocument(workspaceFile, document);
    }

    void generateModulesForApps() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Creating Orion Environment...");
        File modulePath = new File(this.executedProject.getBasedir(), "/modules/orion_env");
        File resourceFile = new File(modulePath, "orion_env-module.xml");
        File imlFile = new File(modulePath, "orion_env.iml");
        modulePath.mkdirs();
        this.modifyEnvModule("atlassian.idea.orion.location", resourceFile, imlFile);
    }

    private void createOrionXml() {
        File baseDir = this.executedProject.getBasedir();
        File orionDir = new File(baseDir, "/orion/persistence/");
        orionDir.mkdirs();
        orionDir = new File(baseDir, "/orion/config/");
        orionDir.mkdirs();
        try {
            String resourceName = "orion-data-sources.xml";
            File orionDataSourceXml = new File(orionDir, "/data-sources.xml");
            Document document = this.readXmlDocument(resourceName);
            Element root = document.getRootElement();
            this.dataSource(root);
            this.writeXmlDocument(orionDataSourceXml, document);
            resourceName = "orion-default-web-site.xml";
            orionDataSourceXml = new File(orionDir, "/default-web-site.xml");
            document = this.readXmlDocument(resourceName);
            root = document.getRootElement();
            root.addAttribute("port", this.appPort);
            if (((Hashtable)this.atlassianProperties).containsKey("atlassian.idea.application.webapp.contextpath")) {
                String contextPath = "/" + this.atlassianProperties.getProperty("atlassian.idea.application.webapp.contextpath");
                this.findElement(root, "web-app", "application", "default").addAttribute("name", "webapp").addAttribute("root", contextPath).addAttribute("load-on-startup", "true");
                this.findElement(root, "default-web-app", "application", "default").addAttribute("name", "");
            } else {
                this.findElement(root, "default-web-app", "application", "default").addAttribute("name", "webapp");
            }
            this.writeXmlDocument(orionDataSourceXml, document);
            resourceName = "orion-application.xml";
            orionDataSourceXml = new File(orionDir, "/application.xml");
            document = this.readXmlDocument(resourceName);
            root = document.getRootElement();
            String mavenWarSrc = this.atlassianProperties.getProperty("maven.war.src");
            if (this.atlassianProperties.getProperty("maven.war.src") == null) {
                throw new MojoExecutionException("maven.war.src variable not set\nPlease set maven.war.src variable your webapp directory (relative to the project root)");
            }
            root.element("web-module").addAttribute("path", this.executedProject.getBasedir() + "/" + mavenWarSrc);
            this.writeXmlDocument(orionDataSourceXml, document);
            String name = "/default/orion-server.xml";
            orionDataSourceXml = new File(orionDir, "/server.xml");
            FileUtils.copyURLToFile((URL)((Object)((Object)this)).getClass().getResource(name), (File)orionDataSourceXml);
            name = "/default/orion-global-web-application.xml";
            orionDataSourceXml = new File(orionDir, "/global-web-application.xml");
            FileUtils.copyURLToFile((URL)((Object)((Object)this)).getClass().getResource(name), (File)orionDataSourceXml);
            name = "/default/orion-mime.types";
            orionDataSourceXml = new File(orionDir, "/mime.types");
            FileUtils.copyURLToFile((URL)((Object)((Object)this)).getClass().getResource(name), (File)orionDataSourceXml);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (MojoExecutionException e) {
            e.printStackTrace();
        }
    }

    private void dataSource(Element root) {
        if (((Hashtable)this.atlassianProperties).containsKey("atlassian.idea.application.db.jndiname")) {
            String jndiName = this.atlassianProperties.getProperty("atlassian.idea.application.db.jndiname");
            String driverName = this.atlassianProperties.getProperty("atlassian.idea.application.db.drivername");
            String url = this.atlassianProperties.getProperty("atlassian.idea.application.db.url");
            String username = this.atlassianProperties.getProperty("atlassian.idea.application.db.username");
            String password = this.atlassianProperties.getProperty("atlassian.idea.application.db.password");
            this.findElement(root, "data-source").addAttribute("location", jndiName).addAttribute("username", username).addAttribute("password", password).addAttribute("connection-driver", driverName).addAttribute("url", url).addAttribute("inactivity-timeout", "30").addAttribute("class", "com.evermind.sql.DriverManagerDataSource").addAttribute("name", "database");
        }
    }
}

