/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins;

import com.atlassian.maven.plugins.AbstractIdeaMojo;
import java.io.File;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.dom4j.Document;
import org.dom4j.Element;

public class IdeaProjectMojo
extends AbstractIdeaMojo {
    private String jdkName;
    private String jdkLevel;
    private String wildcardResourcePatterns;
    private String ideaVersion;
    private Set macros;
    private Properties atlassianProperties;

    public void initParam(MavenProject project, ArtifactFactory artifactFactory, ArtifactRepository localRepo, ArtifactResolver artifactResolver, ArtifactMetadataSource artifactMetadataSource, Log log, boolean overwrite, String jdkName, String jdkLevel, String wildcardResourcePatterns, String ideaVersion, Set macros) {
        super.initParam(project, artifactFactory, localRepo, artifactResolver, artifactMetadataSource, log, overwrite);
        this.jdkName = jdkName;
        this.jdkLevel = jdkLevel;
        this.wildcardResourcePatterns = wildcardResourcePatterns;
        this.ideaVersion = ideaVersion;
        this.macros = macros;
    }

    public void execute() throws MojoExecutionException {
        try {
            this.doDependencyResolution(this.executedProject, this.localRepo);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to build project dependencies.", e);
        }
        this.rewriteProject();
    }

    public void rewriteProject() throws MojoExecutionException {
        File projectFile = new File(this.executedProject.getBasedir(), this.executedProject.getArtifactId() + ".ipr");
        this.atlassianProperties = this.executedProject.getProperties();
        Document document = this.readXmlDocument(projectFile);
        Element module = document.getRootElement();
        Element component = this.findComponent(module, "ProjectModuleManager");
        Element modules = this.findElement(component, "modules");
        this.addAtlassianModules(modules);
        this.configDefaultCompiler(module);
        this.writeXmlDocument(projectFile, document);
    }

    private void configDefaultCompiler(Element module) {
        Element component = this.findComponent(module, "CompilerConfiguration");
        Element option = this.findElement(component, "option", "DEFAULT_COMPILER");
        if (((Hashtable)this.atlassianProperties).containsKey("atlassian.idea.jikespath")) {
            System.out.println("atlassianProperties = " + this.atlassianProperties.getProperty("atlassian.idea.jikespath"));
            File jikes = new File(this.atlassianProperties.getProperty("atlassian.idea.jikespath"));
            if (jikes.exists()) {
                option.addAttribute("value", "Jikes");
            }
        } else {
            option.addAttribute("value", "Javac");
        }
    }

    private void addAtlassianModules(Element modules) {
        this.findModule(modules, "$PROJECT_DIR$/modules/test_env/test_env.iml");
        File funcTests = new File(this.executedProject.getBasedir(), "subprojects/func_tests");
        if (funcTests.exists()) {
            this.findModule(modules, "$PROJECT_DIR$/modules/func_test_env/func_test_env.iml");
        }
    }
}

