/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins;

import com.atlassian.maven.plugins.AbstractIdeaMojo;
import com.atlassian.maven.plugins.SourceInclude;
import com.atlassian.maven.plugins.SourceIncludeConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.dom4j.Document;
import org.dom4j.Element;

public class IdeaModuleMojo
extends AbstractIdeaMojo {
    public void execute() throws MojoExecutionException {
        try {
            this.doDependencyResolution(this.executedProject, this.localRepo);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to build project dependencies.", e);
        }
        this.rewriteModule();
    }

    public void rewriteModule() throws MojoExecutionException {
        this.initAtlassianVariables();
        File moduleFile = new File(this.executedProject.getBasedir(), this.executedProject.getArtifactId() + ".iml");
        Document document = this.readXmlDocument(moduleFile);
        Element module = document.getRootElement();
        Element component = this.findComponent(module, "NewModuleRootManager");
        Element content = this.findElement(component, "content");
        this.removeResourcesFromSources(content);
        this.createBuildResource(component);
        this.createTestResource(component);
        this.createServerExcludes(content);
        this.setupGlobalLibraries(component);
        this.setupClassLibrarySources(component);
        this.writeXmlDocument(moduleFile, document);
    }

    private void removeResourcesFromSources(Element content) {
        String relativeDir;
        String directory;
        Resource resource;
        Iterator i = this.executedProject.getBuild().getResources().iterator();
        while (i.hasNext()) {
            resource = (Resource)i.next();
            directory = resource.getDirectory();
            if (resource.getTargetPath() == null && !resource.isFiltering()) {
                relativeDir = this.getModuleFileUrl(directory);
                this.deleteSourceFolder(content, relativeDir, false);
                continue;
            }
            this.getLog().info((CharSequence)("Not adding resource directory as it has an incompatible target path or filtering: " + directory));
        }
        i = this.executedProject.getBuild().getTestResources().iterator();
        while (i.hasNext()) {
            resource = (Resource)i.next();
            directory = resource.getDirectory();
            if (resource.getTargetPath() == null && !resource.isFiltering()) {
                relativeDir = this.getModuleFileUrl(directory);
                this.deleteSourceFolder(content, relativeDir, true);
                continue;
            }
            this.getLog().info((CharSequence)("Not adding test resource directory as it has an incompatible target path or filtering: " + directory));
        }
    }

    private void setupClassLibrarySources(Element root) throws MojoExecutionException {
        String source = this.atlassianProperties.getProperty("sourceXML.location");
        String moduleRelativeBaseDir = this.atlassianProperties.getProperty("module.relative.base.dir");
        if (source != null && moduleRelativeBaseDir != null) {
            File sourcePath = new File(this.executedProject.getBasedir(), source);
            SourceIncludeConfiguration sic = new SourceIncludeConfiguration(this.log, sourcePath);
            LinkedList sources = sic.getSourceInclude();
            for (int i = 0; i < sources.size(); ++i) {
                File path = null;
                SourceInclude sourceObject = (SourceInclude)sources.get(i);
                if (sourceObject.getSource() == null) continue;
                String moduleDir = sourceObject.getSource();
                String pathNameM1 = this.executedProject.getBasedir() + "/" + moduleRelativeBaseDir + "/" + moduleDir + "/src/java";
                String pathNameM2 = this.executedProject.getBasedir() + "/" + moduleRelativeBaseDir + "/" + moduleDir + "/src/main/java";
                File pathM1 = new File(pathNameM1);
                File pathM2 = new File(pathNameM2);
                if (pathM1.exists()) {
                    path = pathM1;
                } else if (pathM2.exists()) {
                    path = pathM2;
                }
                if (path == null) continue;
                Iterator children = root.elementIterator("orderEntry");
                while (children.hasNext()) {
                    Element orderEntry = (Element)children.next();
                    String type = orderEntry.attributeValue("type");
                    if (!"module-library".equals(type)) continue;
                    Element lib = orderEntry.element("library");
                    String name = lib.attributeValue("name");
                    if (!sourceObject.getArtifactId().equals(name)) continue;
                    Element sourceTag = lib.element("SOURCES");
                    if (sourceTag != null) {
                        lib.remove(sourceTag);
                    }
                    sourceTag = this.findElement(lib, "SOURCES");
                    try {
                        this.findElement(sourceTag, "root", "url", this.invertSlashes("file://" + path.getCanonicalPath()));
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Path is malformed", (Exception)e);
                    }
                }
            }
        }
    }

    private void setupGlobalLibraries(Element node) throws MojoExecutionException {
        if (this.atlassianProperties.getProperty("atlassian.idea.global.libraries.to.enable") != null) {
            String globalLibraries = this.atlassianProperties.getProperty("atlassian.idea.global.libraries.to.enable");
            try {
                String[] globalLibrariesArray = globalLibraries.split(",");
                for (int i = 0; i < globalLibrariesArray.length; ++i) {
                    Element orderEntry = this.findElement(node, "orderEntry", "name", globalLibrariesArray[i]);
                    orderEntry.addAttribute("type", "library");
                    orderEntry.addAttribute("level", "application");
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Cannot add libraries", e);
            }
        }
    }

    private void createServerExcludes(Element content) {
        String baseDir = this.executedProject.getBasedir().toString();
        this.createExclude(content, "/release");
        this.createExclude(content, "/resin/cache");
        this.createExclude(content, "/resin/database");
        this.createExclude(content, "/resin/logs");
        this.createExclude(content, "/resin/tmp");
        this.createExclude(content, "/resin/work");
        this.createExclude(content, "/resin3/logs");
        this.createExclude(content, "/resin3/tmp");
        this.createExclude(content, "/resin3/webapps");
        this.createExclude(content, "/resin3/WEB-INF");
        this.createExclude(content, "/resin3/work");
        this.createExclude(content, "/tomcat/logs");
        this.createExclude(content, "/tomcat/work");
        this.createExclude(content, "/orion/application-deployments");
        this.createExclude(content, "/orion/log");
        this.createExclude(content, "/orion/persistence");
        String relPath = this.getModuleFileUrl(baseDir + "/conf-sourcerelease/confluence/target");
        this.findElement(content, "excludeFolder", "url", relPath);
        relPath = this.getModuleFileUrl(baseDir + "/conf-acceptance-test/target");
        this.findElement(content, "excludeFolder", "url", relPath);
    }

    private void createExclude(Element content, String dir) {
        this.findElement(content, "excludeFolder", "url", "file://$MODULE_DIR$" + dir);
    }

    private void createTestResource(Element component) {
        Element lib = this.createResource(component, "Test Resources");
        Element classesChild = lib.element("CLASSES");
        if (classesChild == null) {
            classesChild = this.createElement(lib, "CLASSES");
        }
        this.removeOldElements(classesChild, "root");
        Iterator i = this.executedProject.getBuild().getTestResources().iterator();
        while (i.hasNext()) {
            Resource resource = (Resource)i.next();
            String directory = resource.getDirectory();
            if (resource.getTargetPath() != null || resource.isFiltering()) continue;
            String relativeDir = this.getModuleFileUrl(directory);
            this.findElement(classesChild, "root", "url", relativeDir);
        }
    }

    private Element createResource(Element component, String resourceName) {
        boolean resourceFound = false;
        Element lib = null;
        Iterator children = component.elementIterator("orderEntry");
        while (children.hasNext()) {
            String name;
            Element orderEntry = (Element)children.next();
            String type = orderEntry.attributeValue("type");
            if (!"module-library".equals(type) || !resourceName.equals(name = (lib = orderEntry.element("library")).attributeValue("name"))) continue;
            resourceFound = true;
        }
        if (!resourceFound) {
            Element orderEntry = this.createElement(component, "orderEntry").addAttribute("type", "module-library").addAttribute("exported", "");
            lib = this.createElement(orderEntry, "library").addAttribute("name", resourceName);
        }
        return lib;
    }

    private void createBuildResource(Element component) {
        Element lib = this.createResource(component, "Build Resources");
        Element classesChild = lib.element("CLASSES");
        if (classesChild == null) {
            classesChild = this.createElement(lib, "CLASSES");
        }
        this.removeOldElements(classesChild, "root");
        Iterator i = this.executedProject.getBuild().getResources().iterator();
        while (i.hasNext()) {
            Resource resource = (Resource)i.next();
            String directory = resource.getDirectory();
            if (resource.getTargetPath() != null || resource.isFiltering()) continue;
            String relativeDir = this.getModuleFileUrl(directory);
            this.findElement(classesChild, "root", "url", relativeDir);
        }
        String extraResources = this.atlassianProperties.getProperty("atlassian.idea.extra.resources");
        if (extraResources != null) {
            StringTokenizer extraResourceTokens = new StringTokenizer(extraResources, ",");
            while (extraResourceTokens.hasMoreTokens()) {
                String extraResourceDir = extraResourceTokens.nextToken();
                this.findElement(classesChild, "root", "url", extraResourceDir);
            }
        }
    }

    private void deleteSourceFolder(Element content, String directory, boolean b) {
        Iterator children = content.elementIterator();
        while (children.hasNext()) {
            Element child = (Element)children.next();
            if (!"sourceFolder".equals(child.getName())) continue;
            Boolean bool = new Boolean(b);
            String test = bool.toString();
            if (!directory.equals(child.attributeValue("url")) || !test.equals(child.attributeValue("isTestSource"))) continue;
            content.remove(child);
        }
    }

    private String getModuleFileUrl(File basedir, String path) {
        return "file://$MODULE_DIR$/" + this.toRelative(basedir, path);
    }

    private String getModuleFileUrl(String file) {
        return this.getModuleFileUrl(this.executedProject.getBasedir(), file);
    }
}

