/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.idea.IdeaXmlWriter;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public abstract class AbstractIdeaMojo
extends AbstractMojo {
    protected MavenProject executedProject;
    protected Log log;
    protected boolean overwrite;
    protected ArtifactFactory artifactFactory;
    protected ArtifactRepository localRepo;
    protected ArtifactResolver artifactResolver;
    protected ArtifactMetadataSource artifactMetadataSource;
    protected String appParams;
    protected String appPort;
    protected Properties atlassianProperties;

    public void initParam(MavenProject project, ArtifactFactory artifactFactory, ArtifactRepository localRepo, ArtifactResolver artifactResolver, ArtifactMetadataSource artifactMetadataSource, Log log, boolean overwrite) {
        this.executedProject = project;
        this.log = log;
        this.artifactFactory = artifactFactory;
        this.localRepo = localRepo;
        this.artifactResolver = artifactResolver;
        this.artifactMetadataSource = artifactMetadataSource;
        this.overwrite = overwrite;
    }

    protected Document readXmlDocument(File file) throws MojoExecutionException {
        try {
            SAXReader reader = new SAXReader();
            return reader.read(file);
        }
        catch (DocumentException e) {
            throw new MojoExecutionException("Please Run   $ mvn idea:idea    before this.", (Exception)((Object)e));
        }
    }

    protected Document readXmlDocument(String fileName) throws MojoExecutionException {
        try {
            SAXReader reader = new SAXReader();
            String name = "/default/" + fileName;
            InputStream resourceAsStream = ((Object)((Object)this)).getClass().getResourceAsStream(name);
            return reader.read(resourceAsStream);
        }
        catch (DocumentException e) {
            throw new MojoExecutionException("Unable to read file", (Exception)((Object)e));
        }
    }

    protected void writeXmlDocument(File file, Document document) throws MojoExecutionException {
        try {
            IdeaXmlWriter writer = new IdeaXmlWriter(file);
            writer.write(document);
            writer.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write file", (Exception)e);
        }
    }

    protected Element findComponent(Element module, String name) {
        return this.findElement(module, "component", name);
    }

    protected Element findModule(Element module, String path) {
        return this.findElement(module, "module", "filepath", path);
    }

    protected Element findElement(Element element, String elementName, String attributeName, String attributeValue) {
        Iterator children = element.elementIterator(elementName);
        while (children.hasNext()) {
            Element child = (Element)children.next();
            if (!attributeValue.equals(child.attributeValue(attributeName))) continue;
            return child;
        }
        return this.createElement(element, elementName).addAttribute(attributeName, attributeValue);
    }

    protected Element findElement(Element element, String elementName, String attributeName) {
        Iterator children = element.elementIterator(elementName);
        while (children.hasNext()) {
            Element child = (Element)children.next();
            if (!attributeName.equals(child.attributeValue("name"))) continue;
            return child;
        }
        return this.createElement(element, elementName).addAttribute("name", attributeName);
    }

    protected void removeElement(Element element, String elementName, String attributeName) {
        Iterator children = element.elementIterator(elementName);
        while (children.hasNext()) {
            Element child = (Element)children.next();
            if (!attributeName.equals(child.attributeValue("name"))) continue;
            element.remove(child);
            return;
        }
    }

    protected void removeElement(Element element, String elementName, String attributeName, String attributeValue) {
        Iterator children = element.elementIterator(elementName);
        while (children.hasNext()) {
            Element child = (Element)children.next();
            Iterator attributes = child.attributeIterator();
            while (attributes.hasNext()) {
                Attribute attribute = (Attribute)attributes.next();
                if (!attributeName.equals(attribute.getName()) || !attributeValue.equals(attribute.getValue())) continue;
                element.remove(child);
            }
        }
    }

    protected Element findElement(Element component, String name) {
        Element element = component.element(name);
        if (element == null) {
            element = this.createElement(component, name);
        }
        return element;
    }

    protected Element findElementWithAttribute(Element element, String elementName, String attributeName) {
        Iterator children = element.elementIterator(elementName);
        while (children.hasNext()) {
            Element child = (Element)children.next();
            Iterator attributes = child.attributeIterator();
            while (attributes.hasNext()) {
                Attribute attribute = (Attribute)attributes.next();
                if (!attributeName.equals(attribute.getName())) continue;
                return child;
            }
        }
        return this.createElement(element, elementName);
    }

    protected Element createElement(Element module, String name) {
        return module.addElement(name);
    }

    protected String toRelative(File basedir, String absolutePath) {
        String relative = absolutePath.startsWith(basedir.getAbsolutePath()) ? absolutePath.substring(basedir.getAbsolutePath().length() + 1) : absolutePath;
        relative = StringUtils.replace((String)relative, (String)"\\", (String)"/");
        return relative;
    }

    protected void removeOldElements(Element content, String name) {
        Iterator children = content.elementIterator();
        while (children.hasNext()) {
            Element child = (Element)children.next();
            if (!name.equals(child.getName())) continue;
            content.remove(child);
        }
    }

    protected String invertSlashes(String s) {
        if (s != null) {
            return s.replace('\\', '/');
        }
        return null;
    }

    protected void doDependencyResolution(MavenProject project, ArtifactRepository localRepo) throws InvalidDependencyVersionException, ProjectBuildingException {
        Map managedVersions = this.createManagedVersionMap(this.artifactFactory, project.getId(), project.getDependencyManagement());
        try {
            ArtifactResolutionResult result = this.artifactResolver.resolveTransitively(this.getProjectArtifacts(), project.getArtifact(), managedVersions, localRepo, project.getRemoteArtifactRepositories(), this.artifactMetadataSource);
            project.setArtifacts(result.getArtifacts());
        }
        catch (ArtifactNotFoundException e) {
            this.getLog().debug((CharSequence)e.getMessage(), (Throwable)e);
            StringBuffer msg = new StringBuffer();
            msg.append("An error occurred during dependency resolution.\n\n");
            msg.append("    Failed to retrieve " + e.getDownloadUrl() + "\n");
            msg.append("from the following repositories:");
            Iterator repositories = e.getRemoteRepositories().iterator();
            while (repositories.hasNext()) {
                ArtifactRepository repository = (ArtifactRepository)repositories.next();
                msg.append("\n    " + repository.getId() + "(" + repository.getUrl() + ")");
            }
            msg.append("\nCaused by: " + e.getMessage());
            this.getLog().warn((CharSequence)msg);
        }
        catch (ArtifactResolutionException e) {
            this.getLog().debug((CharSequence)e.getMessage(), (Throwable)e);
            StringBuffer msg = new StringBuffer();
            msg.append("An error occurred during dependency resolution of the following artifact:\n\n");
            msg.append("    " + e.getGroupId() + ":" + e.getArtifactId() + e.getVersion() + "\n\n");
            msg.append("Caused by: " + e.getMessage());
            this.getLog().warn((CharSequence)msg);
        }
    }

    protected String getPluginSetting(String artifactId, String optionName, String defaultValue) {
        Iterator it = this.executedProject.getBuildPlugins().iterator();
        while (it.hasNext()) {
            Xpp3Dom o;
            Plugin plugin = (Plugin)it.next();
            if (!plugin.getArtifactId().equals(artifactId) || (o = (Xpp3Dom)plugin.getConfiguration()) == null || o.getChild(optionName) == null) continue;
            return o.getChild(optionName).getValue();
        }
        return defaultValue;
    }

    private Set getProjectArtifacts() {
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        Iterator dependencies = this.executedProject.getDependencies().iterator();
        while (dependencies.hasNext()) {
            Dependency dep = (Dependency)dependencies.next();
            String groupId = dep.getGroupId();
            String artifactId = dep.getArtifactId();
            VersionRange versionRange = VersionRange.createFromVersion((String)dep.getVersion());
            String type = dep.getType();
            if (type == null) {
                type = "jar";
            }
            String classifier = dep.getClassifier();
            boolean optional = dep.isOptional();
            String scope = dep.getScope();
            if (scope == null) {
                scope = "compile";
            }
            Artifact artifact = this.artifactFactory.createDependencyArtifact(groupId, artifactId, versionRange, type, classifier, scope, optional);
            if (scope.equalsIgnoreCase("system")) {
                artifact.setFile(new File(dep.getSystemPath()));
            }
            ArrayList<String> exclusions = new ArrayList<String>();
            Iterator j = dep.getExclusions().iterator();
            while (j.hasNext()) {
                Exclusion e = (Exclusion)j.next();
                exclusions.add(e.getGroupId() + ":" + e.getArtifactId());
            }
            ExcludesArtifactFilter newFilter = new ExcludesArtifactFilter(exclusions);
            artifact.setDependencyFilter((ArtifactFilter)newFilter);
            artifacts.add(artifact);
        }
        return artifacts;
    }

    private Map createManagedVersionMap(ArtifactFactory artifactFactory, String projectId, DependencyManagement dependencyManagement) throws ProjectBuildingException {
        HashMap<String, Artifact> map;
        if (dependencyManagement != null && dependencyManagement.getDependencies() != null) {
            map = new HashMap<String, Artifact>();
            Iterator i = dependencyManagement.getDependencies().iterator();
            while (i.hasNext()) {
                Dependency d = (Dependency)i.next();
                try {
                    VersionRange versionRange = VersionRange.createFromVersionSpec((String)d.getVersion());
                    Artifact artifact = artifactFactory.createDependencyArtifact(d.getGroupId(), d.getArtifactId(), versionRange, d.getType(), d.getClassifier(), d.getScope(), d.isOptional());
                    map.put(d.getManagementKey(), artifact);
                }
                catch (InvalidVersionSpecificationException e) {
                    throw new ProjectBuildingException(projectId, "Unable to parse version '" + d.getVersion() + "' for dependency '" + d.getManagementKey() + "': " + e.getMessage(), (Throwable)e);
                }
            }
        } else {
            map = Collections.EMPTY_MAP;
        }
        return map;
    }

    public Log getLog() {
        if (this.log == null) {
            this.log = super.getLog();
        }
        return this.log;
    }

    protected void initAtlassianVariables() {
        this.atlassianProperties = this.executedProject.getProperties();
        this.appParams = this.atlassianProperties.getProperty("atlassian.idea.application.params");
        this.appParams = this.appParams == null ? "-Xms128m -Xmx256m" : this.appParams;
        this.appPort = this.atlassianProperties.getProperty("atlassian.idea.application.port");
        this.appPort = this.appPort == null ? "8080" : this.appPort;
    }

    protected void replace(File file, String regex, String replacement) throws MojoExecutionException {
        try {
            String line;
            if (replacement == null) {
                replacement = "";
            }
            File tempFile = File.createTempFile("temp", "temp");
            BufferedReader reader = new BufferedReader(new FileReader(file));
            BufferedWriter writer = new BufferedWriter(new FileWriter(tempFile));
            while ((line = reader.readLine()) != null) {
                line = line.replaceAll(regex, replacement);
                writer.write(line);
                writer.newLine();
            }
            writer.close();
            reader.close();
            file.delete();
            tempFile.renameTo(file);
        }
        catch (IOException e) {
            throw new MojoExecutionException("failed to read/write to file");
        }
    }

    protected void modifyResinEnvModule(File dir, boolean isResin3) throws MojoExecutionException {
        String moduleXml;
        String property;
        String imlFile;
        String regex;
        if (isResin3) {
            this.getLog().info((CharSequence)"Creating Resin 3 Environment...");
            regex = "\\$\\{atlassian.idea.resin3.location\\}";
            imlFile = "resin3_env.iml";
            property = this.invertSlashes(this.atlassianProperties.getProperty("atlassian.idea.resin3.location"));
            moduleXml = "resin3_env-module";
        } else {
            this.getLog().info((CharSequence)"Creating Resin Environment...");
            regex = "\\$\\{atlassian.idea.resin.location\\}";
            imlFile = "resin_env.iml";
            property = this.invertSlashes(this.atlassianProperties.getProperty("atlassian.idea.resin.location"));
            moduleXml = "resin_env-module";
        }
        dir.mkdirs();
        File moduleFile = new File(dir, imlFile);
        String resourceName = moduleXml + ".xml";
        Document document = this.readXmlDocument(resourceName);
        Element module = document.getRootElement();
        this.replaceURLElement(module, regex, property);
        this.replaceJavaVersion(module);
        this.replaceArtifactId(module);
        this.writeXmlDocument(moduleFile, document);
    }

    protected void replaceJavaVersion(Element module) {
        String jdkName = this.atlassianProperties.getProperty("atlassian.idea.jdk.name");
        if (!((Hashtable)this.atlassianProperties).contains("atlassian.idea.jdk.name") || jdkName.length() <= 0) {
            jdkName = System.getProperties().getProperty("java.version");
            jdkName = jdkName.substring(0, 3);
        }
        Element component = this.findComponent(module, "NewModuleRootManager");
        this.findElement(component, "orderEntry", "type", "jdk").addAttribute("jdkName", jdkName);
    }

    protected void replaceURLElement(Element module, String regex, String property) {
        Element component = this.findElement(module, "component", "NewModuleRootManager");
        Element resinLibraries = this.findElement(component, "orderEntry", "type", "module-library").element("library").element("CLASSES");
        Iterator children = resinLibraries.elementIterator("root");
        while (children.hasNext()) {
            Element child = (Element)children.next();
            String replaceStr = child.attributeValue("url").replaceFirst(regex, property);
            child.addAttribute("url", replaceStr);
        }
    }

    protected void modifyIpr(String modulePath) throws MojoExecutionException {
        File projectFile = new File(this.executedProject.getBasedir(), this.executedProject.getArtifactId() + ".ipr");
        Document document = this.readXmlDocument(projectFile);
        Element module = document.getRootElement();
        Element component = this.findComponent(module, "ProjectModuleManager");
        Element modules = this.findElement(component, "modules");
        Element m = this.findModule(modules, modulePath);
        this.writeXmlDocument(projectFile, document);
    }

    protected void createOptions(Element conf, String mainClassName, String vmParam, String programParam, String workingDir, String moduleName) {
        this.findElement(conf, "option", "MAIN_CLASS_NAME").addAttribute("value", mainClassName);
        this.findElement(conf, "option", "VM_PARAMETERS").addAttribute("value", vmParam);
        this.findElement(conf, "option", "PROGRAM_PARAMETERS").addAttribute("value", programParam);
        this.findElement(conf, "option", "WORKING_DIRECTORY").addAttribute("value", workingDir);
        this.findElement(conf, "module", moduleName);
    }

    protected void replaceArtifactId(Element module) throws MojoExecutionException {
        if (this.atlassianProperties.getProperty("appserver.module.dependency") != null) {
            Element component = this.findElement(module, "component", "NewModuleRootManager");
            this.removeElement(component, "orderEntry", "type", "module");
            String dependency = this.atlassianProperties.getProperty("appserver.module.dependency");
            this.findElement(component, "orderEntry", "type", "module").addAttribute("module-name", dependency);
            if (dependency.equals("confluence")) {
                this.createElement(component, "orderEntry").addAttribute("type", "module").addAttribute("module-name", "confluencerpc");
                this.createElement(component, "orderEntry").addAttribute("type", "module").addAttribute("module-name", "functestrpc");
            }
        } else {
            throw new MojoExecutionException("appserver.module.dependency variable not set\nPlease set appserver.module.dependency variable to a module that contains the needed classes for webapp to run");
        }
    }

    protected void modifyEnvModule(String location, File resourceFile, File imlFile) throws MojoExecutionException {
        String regex = "\\$\\{" + location + "\\}";
        String property = this.invertSlashes(this.atlassianProperties.getProperty(location));
        Document document = this.readXmlDocument(resourceFile.getName());
        Element module = document.getRootElement();
        this.replaceJavaVersion(module);
        this.replaceURLElement(module, regex, property);
        this.replaceArtifactId(module);
        this.writeXmlDocument(imlFile, document);
    }
}

