package com.atlassian.maven.plugins;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.dom4j.Document;
import org.dom4j.Element;

import java.io.File;

/**
 * Created by IntelliJ IDEA.
 * User: Michael
 * Date: 12/09/2006
 * Time: 13:52:18
 * To change this template use File | Settings | File Templates.
 */

/**
 * @author Atlassian
 * @goal resin
 * @execute phase="generate-sources"
 */
public class Resin
        extends AbstractIdeaMojo
{

    public void execute() throws MojoExecutionException, MojoFailureException
    {
        try
        {
            doDependencyResolution(executedProject, localRepo);
        }
        catch (Exception e)
        {
            throw new MojoExecutionException("Unable to build project dependencies.", e);
        }


        build();
    }

    public void build()
            throws MojoExecutionException
    {
        initAtlassianVariables();
        if (executedProject.isExecutionRoot())
        {

            String resinLocation = atlassianProperties.getProperty("atlassian.idea.resin.location");
            if (resinLocation != null)
            {
                File resin = new File(resinLocation + "/lib/resin.jar");
                File resin_env = new File(executedProject.getBasedir(), "/modules/resin_env");
                if (resin.exists())
                {
                    modifyIpr("$PROJECT_DIR$/modules/resin_env/resin_env.iml");
                    modifyIws();
                    modifyResinEnvModule(resin_env, false);
                    createResinXml();
                } else
                {
                    getLog().error("Unable to find resin jar in " + resin.getAbsolutePath());
                }
            }
        }
    }

    private void modifyIws()
            throws MojoExecutionException
    {
        File workspaceFile = new File(executedProject.getBasedir(), executedProject.getArtifactId() + ".iws");

        Document document = readXmlDocument(workspaceFile);
        Element module = document.getRootElement();

        /*Add Atlassian Configuration */
        Element runManager = findComponent(module, "RunManager");


        Element conf = findElement(runManager, "configuration", "Resin")
                .addAttribute("type", "Application")
                .addAttribute("default", "false")
                .addAttribute("selected", "true");
        String mainClassName = "com.caucho.server.http.HttpServer";
        String vmParameters = "-Dresin.home=resin " + appParams;
        String programParameters = "-conf resin.xml";
        String workingDirectory = "$PROJECT_DIR$";
        String moduleName = "resin_env";
        createOptions(conf, mainClassName, vmParameters, programParameters, workingDirectory, moduleName);

        writeXmlDocument(workspaceFile, document);

    }


    private void createResinXml() throws MojoExecutionException
    {
        File baseDir = executedProject.getBasedir();
        File resinDir = new File(baseDir, "/resin/");
        resinDir.mkdirs();

        String resourceName = "resin.xml";


        File resinXml = new File(resinDir, "/resin.xml");

        Document document = readXmlDocument(resourceName);

        Element root = document.getRootElement();
        configDefaultCompiler(root);

        root.element("log").addAttribute("id", baseDir.getAbsolutePath() + "/resin/logs/stdout.log");

        root.element("http-server").element("http").addAttribute("port", appPort);

        root.element("http-server").element("host").element("error-log").addAttribute("id", baseDir.getAbsolutePath() + "/resin/logs/error.log");

        String contextPath = atlassianProperties.getProperty("atlassian.idea.application.webapp.contextpath");
        contextPath = contextPath == null ? "" : contextPath;
        String mavenWarSrc = atlassianProperties.getProperty("maven.war.src");
        if (mavenWarSrc != null)
        {
            root.element("http-server").element("host").element("web-app")
                    .addAttribute("id", "/" + contextPath)
                    .addAttribute("app-dir", executedProject.getBasedir() + "/" + mavenWarSrc);
        } else
        {
            throw new MojoExecutionException("maven.war.src variable not set\n"
                    + "Please set maven.war.src variable your webapp directory (relative to the project root)");
        }

        root.element("http-server").element("host").element("web-app").element("work-dir").setText(baseDir.getAbsolutePath() + "/resin/work");

        root.element("http-server").element("host").element("web-app").element("temp-dir").setText(baseDir.getAbsolutePath() + "/resin/tmp");

        resourceRef(root);
        writeXmlDocument(resinXml, document);

    }

    private void resourceRef(Element root)
    {
        if (atlassianProperties.containsKey("atlassian.idea.application.db.jndiname"))
        {
            Element resource = findElement(root, "resource-ref");
            findElement(resource, "res-type").setText("javax.sql.DataSource");
            findElement(resource, "init-param", "max-connections", "20");
            findElement(resource, "init-param", "max-idle-time", "30");

            String jndiName = atlassianProperties.getProperty("atlassian.idea.application.db.jndiname");
            String driverName = atlassianProperties.getProperty("atlassian.idea.application.db.drivername");
            String url = atlassianProperties.getProperty("atlassian.idea.application.db.url");
            String username = atlassianProperties.getProperty("atlassian.idea.application.db.username");
            String password = atlassianProperties.getProperty("atlassian.idea.application.db.password");

            findElement(resource, "res-ref-name").setText(jndiName);
            findElementWithAttribute(resource, "init-param", "driver-name")
                    .addAttribute("driver-name", driverName);
            findElementWithAttribute(resource, "init-param", "url")
                    .addAttribute("url", url);
            findElementWithAttribute(resource, "init-param", "user")
                    .addAttribute("user", username);
            findElementWithAttribute(resource, "init-param", "password")
                    .addAttribute("password", password);


        }
    }

    private void configDefaultCompiler(Element module)
    {
        Element option = findElement(module, "java")
                .addAttribute("compiler-args", "");
        if (atlassianProperties.containsKey("atlassian.idea.jikespath"))
        {
            String jikesPath = atlassianProperties.getProperty("atlassian.idea.jikespath");
            File jikes = new File(jikesPath);

            if (jikes.exists())
            {
                option.addAttribute("compiler", jikesPath);
                return;
            }


        }
        option.addAttribute("compiler", "jikes");

    }
}
