package com.atlassian.maven.plugins;

/*
 * Copyright 2005-2006 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import org.apache.maven.plugin.MojoExecutionException;
import org.dom4j.Element;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

import java.io.File;
import java.io.InputStream;
import java.util.Properties;
import java.util.Iterator;

/**
 * @author Edwin Punzalan
 * @goal workspace
 * @execute phase="generate-sources"
 */
public class IdeaWorkspaceMojo
        extends AbstractIdeaMojo
{
    private Properties atlassianProperties;

    /**
     * Create IDEA workspace (.iws) file.
     *
     * @throws org.apache.maven.plugin.MojoExecutionException
     *
     */
    public void execute()
            throws MojoExecutionException
    {
        try
        {
            doDependencyResolution(executedProject, localRepo);
        }
        catch (Exception e)
        {
            throw new MojoExecutionException("Unable to build project dependencies.", e);
        }

        rewriteWorkspace();
    }

    public void rewriteWorkspace()
            throws MojoExecutionException
    {
        File workspaceFile = new File(executedProject.getBasedir(), executedProject.getArtifactId() + ".iws");
        atlassianProperties = executedProject.getProperties();
        Document document = readXmlDocument(workspaceFile);

        Element module = document.getRootElement();

        /*Add Atlassian Configuration */
        addAtlassianConfig(module);

        writeXmlDocument(workspaceFile, document);


    }

    private void addAtlassianConfig(Element module)
    {
        Element runManager = findComponent(module, "RunManager");
        String appParams = atlassianProperties.getProperty("atlassian.idea.application.params");

        /*Read in workspace.xml and add the xml into the RunManager Component*/
        InputStream data = getClass().getResourceAsStream("/default/workspace.xml");
        try
        {
            Document atlassianConfig = new SAXReader().read(data);
            Element root = atlassianConfig.getRootElement();
            Iterator iterator = root.elementIterator();
            while (iterator.hasNext())
            {
                Element child = (Element) iterator.next();
                Element newChild = child.createCopy();
                String name = newChild.attributeValue("name");
                removeElement(runManager, "configuration", name);
                runManager.add(newChild);
            }
        } catch (DocumentException e)
        {
            e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
        }

    }


}