package com.atlassian.functest.maven.plugins.mojo

import org.apache.maven.model.Plugin
import static org.twdata.maven.mojoexecutor.MojoExecutor.*
import com.atlassian.functest.maven.plugins.config.CargoBuildConfig

/**
 * @goal startCargo
 * @phase pre-integration-test
 */
public class CargoBuildMojo extends AbstractFuncTestMojo
{
    public void executeMojo()
    {
        // start cargo
        final Plugin cargoPlugin = plugin(groupId('org.codehaus.cargo'), artifactId('cargo-maven2-plugin'), version('0.3.1'))

        final CargoBuildConfig cargoConfig = new CargoBuildConfig()

        cargoConfig.setCargoWait(cargoWait)
        cargoConfig.setHttpPort(httpPort)        
        cargoConfig.setBuildDir(buildDir)
        cargoConfig.setWebappContext(webappContext)
        cargoConfig.setContainerId(containerId)
        cargoConfig.setControllerPort(controllerPort)
        cargoConfig.setJvmArgs(jvmArgs)
        cargoConfig.setDeployable(deployable)
        cargoConfig.setZipUrlInstaller(zipUrlInstaller)
        cargoConfig.setInstallDir(cargoInstallDir)
        cargoConfig.setSystemProperties(systemProperties)

        executeMojo(
            cargoPlugin,
            goal('start'),
            cargoConfig.getConfiguration(),
            executionEnvironment(project, session, pluginManager))
    }
}