package com.atlassian.functest.maven.plugins.mojo

import org.apache.maven.model.Plugin
import com.atlassian.functest.maven.plugins.config.SurefireBuildConfig
import static org.twdata.maven.mojoexecutor.MojoExecutor.*

/**
 * @goal runTests
 * @phase integration-test
 */
public class AcceptanceTestMojo extends AbstractFuncTestMojo
{
    public void executeMojo()
    {
        final Plugin dependencyPlugin = plugin(groupId('org.apache.maven.plugins'), artifactId('maven-dependency-plugin'))

        final String testClassesDirectory = "$buildDir/it-classes"

        executeMojo(
            dependencyPlugin,
            goal('unpack-dependencies'),
            configuration(
                element(name('excludeTransitive'), "true"),
                element(name('includeArtifactIds'), testClassArtifact.get('artifactId')),
                    element(name('outputDirectory'), testClassesDirectory)
                ),
                executionEnvironment(project, session, pluginManager)
        )

        final Plugin mavenSurefirePlugin = plugin(groupId("org.apache.maven.plugins"), artifactId("maven-surefire-plugin"))

        final SurefireBuildConfig setupSurefireConfig = new SurefireBuildConfig()

        setupSurefireConfig.setHttpPort(httpPort)
        setupSurefireConfig.setBuildDir(buildDir)
        setupSurefireConfig.setWebappContext(webappContext)
        setupSurefireConfig.setSmtpPort(smtpPort)
        setupSurefireConfig.setTestClassesDirectory(testClassesDirectory)
        setupSurefireConfig.setTestIncludes(setupIncludes)
        setupSurefireConfig.setSystemProperties(systemProperties)

        // Setup acceptance test
        executeMojo(
            mavenSurefirePlugin,
            goal('test'),
            setupSurefireConfig.getConfiguration(),
            executionEnvironment(project, session, pluginManager))

        final SurefireBuildConfig acceptanceTestSurefireConfig = new SurefireBuildConfig()

        acceptanceTestSurefireConfig.setHttpPort(httpPort)
        acceptanceTestSurefireConfig.setBuildDir(buildDir)
        acceptanceTestSurefireConfig.setWebappContext(webappContext)
        acceptanceTestSurefireConfig.setSmtpPort(smtpPort)
        acceptanceTestSurefireConfig.setTestClassesDirectory(testClassesDirectory)
        acceptanceTestSurefireConfig.setTestIncludes(testIncludes)
        acceptanceTestSurefireConfig.setTestExcludes(testExcludes)
        acceptanceTestSurefireConfig.setSystemProperties(systemProperties)

        // Confluence acceptance tests
        executeMojo(
            mavenSurefirePlugin,
            goal('test'),
            acceptanceTestSurefireConfig.getConfiguration(),
            executionEnvironment(project, session, pluginManager))
    }
}