package com.atlassian.functest.maven.plugins.mojo

import org.apache.maven.project.MavenProject
import org.apache.maven.execution.MavenSession
import org.apache.maven.plugin.PluginManager
import org.codehaus.groovy.maven.mojo.GroovyMojo

/**
 * This abstract class holds all the parameters used by the functional test mojos.
 */
public abstract class AbstractFuncTestMojo extends GroovyMojo
{
    /**
     * The Maven Project
     *
     * @parameter expression="${project}"
     * @required
     * @readonly
     */
    MavenProject project

    /**
     * The Maven Session
     *
     * @parameter expression="${session}"
     * @required
     * @readonly
     */
    MavenSession session

    /**
     * The Maven PluginManager
     *
     * @component
     * @required
     * @readonly
     */
    PluginManager pluginManager

    /**
     * Http Port
     *
     * @parameter alias="http.port"
     * @required
     */
    String httpPort

    /**
     * SMTP Port
     *
     * @parameter alias="smtp.port"
     * @required
     */
    String smtpPort

    /**
     * Webapp Context Path
     *
     * @parameter default-value="" alias="context"   
     */
    String webappContext

    /**
     * Project Build Directory
     *
     * @parameter expression="${project.build.directory}"
     * @required
     * @readonly
     */
    String buildDir

    /**
     * Artifact for tests
     *
     * @parameter
     * @required
     */
    Map<String, String> testClassArtifact

    /**
     * Cargo Rmi Port
     *
     * @parameter alias="controller.port"
     * @required
     */
    String controllerPort

    /**
     * Jvm Arguments
     *
     * @parameter alias="jvm.args"
     * @required
     */
    String jvmArgs

    /**
     * Setup Includes
     *
     * @parameter alias="setupIncludes"
     * @required
     */
    String[] setupIncludes

    /**
     * Test Includes
     *
     * @parameter alias="testIncludes"
     */
    String[] testIncludes

    /**
     * Test Excludes
     *
     * @parameter alias="testExcludes"
     */
    String[] testExcludes

    /**
     * Deployable properties
     * @parameter alias="deployable"
     * @required
     */
    Map<String, String> deployable

    /**
     * Container ID
     * @parameter alias="containerId" default-value="tomcat5x"
     * @required
     */
    String containerId

    /**
     * Zip URL Installer
     * @parameter alias="zipUrlInstaller"
     */
    String zipUrlInstaller

    /**
     * Install Directory
     * @parameter alias="installDir"
     */
    String cargoInstallDir

    /**
     * System Properties
     *
     * @parameter
     */
    Properties systemProperties

    /**
     * Cargo Wait param
     *
     * @parameter default-value="false" expression="${cargo.wait}"
     */
    boolean cargoWait

    /**
     * Skip test param
     *
     * @parameter default-value="false" alias="skip" expression="${maven.test.it.skip}"
     */
    boolean skipTest

    /**
     * Copies the properties to another mojo
     */
    void transferProperties(AbstractFuncTestMojo mojo)
    {
        mojo.setProject project
        mojo.setSession session
        mojo.setPluginManager pluginManager
        mojo.setHttpPort httpPort
        mojo.setSmtpPort smtpPort
        mojo.setWebappContext webappContext
        mojo.setBuildDir buildDir
        mojo.setTestClassArtifact testClassArtifact
        mojo.setControllerPort controllerPort
        mojo.setJvmArgs jvmArgs
        mojo.setSetupIncludes setupIncludes
        mojo.setTestIncludes testIncludes
        mojo.setTestExcludes testExcludes
        mojo.setDeployable deployable
        mojo.setContainerId containerId
        mojo.setZipUrlInstaller zipUrlInstaller
        mojo.setCargoInstallDir cargoInstallDir
        mojo.setSystemProperties systemProperties
    }

    void execute()
    {
        if (skipTest)
        {
            log.println("Skipping...")
            return;
        }
      
        executeMojo();
    }

    abstract void executeMojo();
}