package com.atlassian.functest.maven.plugins.config;

import static org.twdata.maven.mojoexecutor.MojoExecutor.*

import java.util.Properties
import org.twdata.maven.mojoexecutor.MojoExecutor.Element
import org.codehaus.plexus.util.xml.Xpp3Dom
import com.atlassian.functest.maven.plugins.PropertiesBuilder;

public class SurefireBuildConfig implements BuildConfig
{
    // Required
    String httpPort
    String smtpPort
    String webappContext
    String[] testIncludes
    String buildDir
    String testClassesDirectory

    // Optional
    Properties<String, String> systemProperties
    String[] testExcludes

    public Xpp3Dom getConfiguration()
    {
        systemProperties = addDefaultSystemProperties(systemProperties)
        return configuration(
                element(name('systemProperties'),
                    PropertiesBuilder.convertPropertiesToSurefireElements(systemProperties),
                ),
                element(name('testClassesDirectory'), testClassesDirectory),
                element(name('includes'),
                    createElementArray("include", testIncludes)
                ),
                element(name('excludes'),
                    createElementArray("exclude", testExcludes)
                )
        );
    }

    private Element[] createElementArray(String name, String[] values)
    {
        if (values == null)
        {
            return new Element[0];
        }

        Element[] elementArray = new Element[values.length]
        for (int i = 0; i < values.length; i++)
        {
            elementArray[i] = element(name(name), values[i])
        }

        return elementArray
    }

    private Properties<String, String> addDefaultSystemProperties(Properties<String, String> props)
    {
        if (props == null)
            props = new Properties<String, String>();

        props.put('http.port', httpPort)
        props.put('smtp.port', smtpPort)
        props.put('webappContext', "/$webappContext")
        props.put('baseurl', "http://localhost:$httpPort/$webappContext")

        return props;
    }
}
