package com.atlassian.functest.maven.plugins.config

import static org.twdata.maven.mojoexecutor.MojoExecutor.*
import org.codehaus.plexus.util.xml.Xpp3Dom
import com.atlassian.functest.maven.plugins.PropertiesBuilder
import org.twdata.maven.mojoexecutor.MojoExecutor.Element

public class CargoBuildConfig implements BuildConfig
{
    // Required params
    String containerId
    String buildDir
    String httpPort
    String controllerPort
    String jvmArgs
    Map<String, String> deployable
    String webappContext
    String installDir
    boolean cargoWait

    // Optional params
    String zipUrlInstaller
    Properties systemProperties

    public Xpp3Dom getConfiguration()
    {
        if (zipUrlInstaller == null)
        {
            zipUrlInstaller = getContainerZipLocation(containerId)
        }

        return configuration(
                element(name('wait'), cargoWait.toString()),
                element(name('container'),
                    element(name('containerId'), containerId),
                    cargoDownloadConfig(),
                    element(name('output'), "$buildDir/output.log"),
                    element(name('log'), "$buildDir/cargo.log"),
                    element(name('systemProperties'),
                        PropertiesBuilder.convertPropertiesToCargoElements(systemProperties)
                    )
                ),
                element(name('configuration'),
                    element(name('home'), "$buildDir/$containerId/container"), 
                    element(name('properties'),
                        element(name('cargo.servlet.port'), httpPort),
                        element(name('cargo.rmi.port'), controllerPort),
                        element(name('cargo.jvmargs'), jvmArgs)
                    ),
                    element(name('deployables'),
                        element(name('deployable'),
                            element(name('groupId'), deployable.get('groupId')),
                            element(name('artifactId'), deployable.get('artifactId')),
                            element(name('type'), deployable.get('type')),
                            element(name('pingURL'), "http://localhost:$httpPort/$webappContext"),
                            element(name('pingTimeout'), '60000'),
                            element(name('properties'),
                                element(name('context'), webappContext)
                            )
                        )
                    )
                )
            )
    }

    private Element cargoDownloadConfig()
    {
        if (installDir != null)
            return element(name('zipUrlInstaller'),
                element(name('url'), zipUrlInstaller),
                element(name('installDir'), installDir)
            );
        else
            return element(name('zipUrlInstaller'),
                element(name('url'), zipUrlInstaller),
            );
    }

    public String getContainerZipLocation(String containerId)
    {
        return "http://repository.atlassian.com/maven2/org/apache/tomcat/apache-tomcat/5.5.25/apache-tomcat-5.5.25.zip";
    }
}