package com.atlassian.functest.maven.plugins

import org.twdata.maven.mojoexecutor.MojoExecutor.Element
import static org.twdata.maven.mojoexecutor.MojoExecutor.*

public class PropertiesBuilder
{
    public static Element[] convertPropertiesToCargoElements(Properties properties)
    {
        Element[] propArray

        if (properties != null)
        {
            propArray = new Element[properties.size()]

            properties.eachWithIndex ({
                String key, String value, int index ->
                    propArray[index] = element(name(key) , value)
            })
        }
        else
        {
            propArray = new Element[0]
        }

        return propArray
    }

    public static Element[] convertPropertiesToSurefireElements(Properties properties)
    {
        Element[] propArray

        if (properties != null)
        {
            propArray = new Element[properties.size()]

            properties.eachWithIndex ({
                String key, String value, int index ->
                    propArray[index] = element(name('property'),
                        element(name('name') , key),
                        element(name('value'), value)
                    )
            })
        }
        else
        {
            propArray = new Element[0]
        }

        return propArray
    }
}