/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.confluence.tools.mojo;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="checkout")
public class CheckoutMojo
extends AbstractMojo {
    private static final String TAG = "tag";
    private static final String HEAD = "head";
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="session", required=true, readonly=true)
    private MavenSession session;
    @Component
    private BuildPluginManager pluginManager;
    @Component
    private ProjectBuilder projectBuilder;
    @Parameter(property="checkoutDirectory", defaultValue="${project.build.directory}/checkout")
    private String checkoutDirectory;
    @Parameter(property="artifactIds")
    private String artifactIds;
    @Parameter(property="fromScmBranch", defaultValue="head")
    private String fromScmBranch;

    public void execute() throws MojoExecutionException {
        Plugin scmPlugin = (Plugin)this.project.getPluginManagement().getPluginsAsMap().get("org.apache.maven.plugins:maven-scm-plugin");
        if (scmPlugin == null) {
            throw new MojoExecutionException("license plugin could not be found in <pluginManagement>");
        }
        if (!TAG.equals(this.fromScmBranch) && !HEAD.equals(this.fromScmBranch)) {
            throw new MojoExecutionException("fromScmBranch parameter should be either 'tag' or 'head'");
        }
        Set artifactIdSet = this.artifactIds != null && !"".equals(this.artifactIds.trim()) ? Pattern.compile(",").splitAsStream(this.artifactIds.trim().toLowerCase()).map(String::trim).collect(Collectors.toSet()) : Collections.emptySet();
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        try {
            for (Artifact artifact : this.project.getDependencyArtifacts()) {
                if (!artifact.getGroupId().startsWith("com.atlassian") || !artifactIdSet.contains(artifact.getArtifactId())) continue;
                buildingRequest.setProject(null);
                MavenProject mavenProject = this.projectBuilder.build(artifact, (ProjectBuildingRequest)buildingRequest).getProject();
                MavenProject parentProject = mavenProject.getParent();
                Scm targetScm = mavenProject.getScm();
                Artifact targetArtifact = artifact;
                if (parentProject != null && mavenProject.getOriginalModel().getScm() == null) {
                    targetScm = parentProject.getScm();
                    targetArtifact = parentProject.getArtifact();
                }
                try {
                    ArrayList<MojoExecutor.Element> baseElementStream = new ArrayList<MojoExecutor.Element>();
                    baseElementStream.add(MojoExecutor.element((String)MojoExecutor.name((String)"connectionUrl"), (String)targetScm.getConnection()));
                    baseElementStream.add(MojoExecutor.element((String)MojoExecutor.name((String)"skipCheckoutIfExists"), (String)"true"));
                    if (TAG.equals(this.fromScmBranch)) {
                        String finalScmTag = HEAD.equalsIgnoreCase(targetScm.getTag()) ? String.format("%s-%s", targetArtifact.getArtifactId(), targetArtifact.getVersion()) : targetScm.getTag();
                        baseElementStream.add(MojoExecutor.element((String)MojoExecutor.name((String)"checkoutDirectory"), (String)(this.checkoutDirectory + File.separator + finalScmTag)));
                        baseElementStream.add(MojoExecutor.element((String)MojoExecutor.name((String)"scmVersionType"), (String)TAG));
                        baseElementStream.add(MojoExecutor.element((String)MojoExecutor.name((String)"scmVersion"), (String)finalScmTag));
                    } else {
                        baseElementStream.add(MojoExecutor.element((String)MojoExecutor.name((String)"checkoutDirectory"), (String)(this.checkoutDirectory + File.separator + artifact.getArtifactId())));
                    }
                    MojoExecutor.Element[] configurationElements = baseElementStream.toArray(new MojoExecutor.Element[0]);
                    MojoExecutor.executeMojo((Plugin)scmPlugin, (String)MojoExecutor.goal((String)"checkout"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])configurationElements), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
                }
                catch (MojoExecutionException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException("Error happened while building project!", (Exception)((Object)e));
        }
    }
}

