package com.atlassian.distribution.scriptwriter;

import org.apache.commons.io.IOUtils;

import java.io.File;

import static org.apache.commons.lang3.StringUtils.isNotBlank;

/**
 * Script helper for *nix shell script
 */
public class PosixScriptWriter extends AbstractScriptWriter {
    public PosixScriptWriter(File directory, String filename, boolean withTests) {
        super(directory, filename, withTests);
        this.newLine = IOUtils.LINE_SEPARATOR_UNIX;
        this.extraCli = " \"$@\"";
        this.preliminaryLines.add("#! /bin/sh");
        this.preliminaryLines.add("cd \"`dirname \"$0\"`\"");
    }

    public void addSettingsLine(String settingsFilename) {
        this.preliminaryLines.add("SETTINGSFILE=\"" + settingsFilename + "\"");
        this.addToMavenCommands("-s $SETTINGSFILE");
    }

    public void addLocalRepoLine(String localRepoFilename) {
        this.preliminaryLines.add("LOCALREPO=\"" + localRepoFilename + "\"");
        this.addToMavenCommands("-Dmaven.repo.local=\"`pwd`/$LOCALREPO\"");
    }

    public void addCurrentDirToPath() {
        this.preliminaryLines.add("export PATH=.:$PATH");
    }

    public void useErrorMode() {
        this.preliminaryLines.add("set -e");
    }

    public void addOtherPreliminaryLine(String line) {
        this.preliminaryLines.add(line);
    }

    public void addCommand(String command, boolean isMaven, boolean takesExtraCli) {
        this.addCommand(command, "", isMaven, takesExtraCli);
    }

    public void addCommand(String command, String arguments, boolean isMaven, boolean takesExtraCli) {
        String cmd = command;

        if (isNotBlank(arguments)) {
            cmd = cmd + " " + arguments;
        }

        if (isMaven) {
            cmd = cmd + appendToMavenCommands;
        }

        if (takesExtraCli) {
            cmd = cmd + this.extraCli;
        }
        this.commands.add(cmd);
    }
}
