package com.atlassian.distribution.scriptwriter;

import com.atlassian.distribution.MavenVersion;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Class representing a specific maven command to run
 */
public class FinalMavenBuildCommand {
    public static final MavenVersion DEFAULT_MAVEN_VERSION = MavenVersion.MAVEN305;
    /**
     * @parameter
     */
    private String cmdArgs;

    /**
     * @parameter
     */
    private String mavenVersion;

    public FinalMavenBuildCommand() {
        this.cmdArgs = "";
        this.mavenVersion = "mvn3";
    }

    public String getMavenVersion() {
        return this.mavenVersion;
    }

    public MavenVersion getMavenVersionEnum() throws MojoExecutionException {
        MavenVersion result = DEFAULT_MAVEN_VERSION;
        if (this.mavenVersion != null) {
            result = MavenVersion.getMavenVersion(mavenVersion);
        }
        return result;
    }

    public String getCmdArgs() {
        return this.cmdArgs;
    }
}
