package com.atlassian.distribution.mojo;


import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;

/**
 * Display the default list of dependencies whose source code will not be included
 */
@Mojo(name = "showDefaultExclusion", requiresProject = false)
public class ShowDefaultExclusionsMojo extends AbstractMojo {

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        InputStream is = this.getClass().getResourceAsStream("/excludedArtifacts.txt");
        try {
            List<String> defaultExclusionss = IOUtils.readLines(is);
            is.close();
            getLog().info("\nThe following artifacts' code will not be exported by default\n");
            for (String exclude : defaultExclusionss) {
                getLog().info("\t- " + exclude);
            }
            getLog().info("\n");
        } catch (IOException e) {
            throw new MojoExecutionException("Failed to read default exclusions:", e);
        }

    }
}
