package com.atlassian.distribution;

import org.apache.maven.plugin.MojoExecutionException;

import static java.lang.String.format;
import static java.util.Arrays.stream;
import static java.util.stream.Collectors.joining;

public enum MavenVersion {
    MAVEN305("mvn305", "3.0.5"),
    MAVEN325("mvn325", "3.2.5"),
    MAVEN339("mvn339", "3.3.9"),
    MAVEN354("mvn354", "3.5.4"),
    MAVEN363("mvn363", "3.6.3"),
    MAVEN383("mvn383", "3.8.3");

    public static final String MAVEN_CMD_POSIX = "sh";
    public static final String MAVEN_CMD_WIN = "bat";

    private final String mavenRunnerCmd;
    private final String versionString;

    MavenVersion(
            final String mavenRunnerCmd,
            final String versionString
    ) {
        this.mavenRunnerCmd = mavenRunnerCmd;
        this.versionString = versionString;
    }

    public String getMavenRunnerCmd() {
        return mavenRunnerCmd;
    }

    public String getVersionString() {
        return versionString;
    }

    public static MavenVersion getMavenVersion(final String versionNumber) throws MojoExecutionException {
        return stream(MavenVersion.values())
                .filter(v -> v.getVersionString().equals(versionNumber))
                .findFirst()
                .orElseThrow(() -> new MojoExecutionException(format(
                        "Invalid maven version: %s. Supported versions include: %s",
                        versionNumber,
                        stream(MavenVersion.values()).map(v -> v.versionString).collect(joining(", ")))
                ));
    }
}
