/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.dependency.mojo;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;

@Mojo(name="export-scm-csv")
public class ExportScmCsvMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="session", required=true, readonly=true)
    private MavenSession session;
    @Component
    private BuildPluginManager pluginManager;
    @Component
    private ProjectBuilder projectBuilder;
    @Parameter(property="outputFilename", required=true)
    private String outputFilename;
    @Parameter(property="exceptionOnMissingScm", defaultValue="false")
    private boolean exceptionOnMissingScm;
    @Parameter(property="gavRegex", defaultValue="com\\.atlassian\\..*:.*:.*")
    private String gavRegex;
    private Pattern gavPattern;
    private ProjectBuildingRequest buildingRequest;
    private SortedSet<DependencyEntry> entries;
    private Set<MavenProject> visited;

    public void execute() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"ExportScmCsvMojo:list starting...");
        this.gavPattern = Pattern.compile(this.gavRegex);
        this.buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        this.entries = new TreeSet<DependencyEntry>();
        this.visited = new HashSet<MavenProject>();
        try {
            this.visit(this.project);
            this.printCsvReport();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error happened while building project!", e);
        }
    }

    private void visit(MavenProject currentProject) throws ProjectBuildingException, MojoExecutionException {
        if (this.visited.contains(currentProject)) {
            return;
        }
        this.visited.add(currentProject);
        for (Artifact artifact : this.project.getDependencyArtifacts()) {
            MavenProject dependantProject;
            String gav = this.toGav(artifact);
            if (!this.gavPattern.matcher(gav).matches()) {
                this.getLog().debug((CharSequence)String.format("Skipping '%s' as it does not match regex '%s'", gav, this.gavRegex));
                continue;
            }
            MavenProject targetProject = dependantProject = this.projectBuilder.build(artifact, this.buildingRequest).getProject();
            while (targetProject.getOriginalModel().getScm() == null && targetProject.getParent() != null) {
                targetProject = targetProject.getParent();
            }
            if (targetProject.getScm() == null) {
                String error = String.format("Could not find scm element for project '%s'", dependantProject.getArtifactId());
                this.getLog().warn((CharSequence)error);
                if (!this.exceptionOnMissingScm) continue;
                throw new MojoExecutionException(error);
            }
            this.entries.add(new DependencyEntry(dependantProject.getArtifactId(), targetProject));
            this.visit(dependantProject);
        }
    }

    private void printCsvReport() throws IOException {
        if (this.entries.isEmpty()) {
            return;
        }
        String reportBody = this.entries.stream().map(DependencyEntry::toCsv).collect(Collectors.joining(System.lineSeparator())) + System.lineSeparator();
        Path reportPath = Paths.get(this.outputFilename, new String[0]);
        Files.createDirectories(reportPath.getParent(), new FileAttribute[0]);
        if (Files.notExists(reportPath, new LinkOption[0])) {
            Files.createFile(reportPath, new FileAttribute[0]);
        }
        Files.write(reportPath, reportBody.getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
    }

    private String toGav(Artifact artifact) {
        return artifact.getGroupId() + ':' + artifact.getArtifactId() + ':' + artifact.getVersion();
    }

    private static class DependencyEntry
    implements Comparable<DependencyEntry> {
        private String artifactId;
        private String connection;
        private String url;

        public DependencyEntry(String artifactId, MavenProject project) {
            this.artifactId = artifactId;
            this.connection = project.getScm().getConnection();
            this.url = project.getScm().getUrl();
        }

        public String toCsv() {
            String conn = this.connection.replace("scm:git:", "");
            return this.artifactId + "," + conn + "," + this.url;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DependencyEntry that = (DependencyEntry)o;
            return this.artifactId.equals(that.artifactId) && this.connection.equals(that.connection) && this.url.equals(that.url);
        }

        public int hashCode() {
            return Objects.hash(this.artifactId, this.connection, this.url);
        }

        @Override
        public int compareTo(DependencyEntry o) {
            return this.artifactId.compareTo(o.artifactId);
        }
    }
}

