/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.ampsdispatcher;

import com.atlassian.maven.plugins.amps.product.ProductHandlerFactory;
import com.atlassian.maven.plugins.amps.util.MojoUtils;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public abstract class AbstractAmpsDispatcherMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    MavenProject project;
    @Parameter(property="session", required=true, readonly=true)
    MavenSession session;
    @Component
    BuildPluginManager buildPluginManager;

    public final void execute() throws MojoExecutionException, MojoFailureException {
        String goal = this.session.getGoals().stream().findFirst().map(AbstractAmpsDispatcherMojo::determineGoal).orElseThrow(() -> new MojoFailureException("No goals were specified to dispatch"));
        Plugin plugin = this.findProductPlugin().orElseThrow(() -> new MojoFailureException("Couldn't detect an AMPS plugin to dispatch to"));
        MojoUtils.executeWithMergedConfig((Plugin)plugin, (String)goal, (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[0]), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.buildPluginManager));
    }

    static String determineGoal(String goal) {
        return goal.substring(goal.lastIndexOf(":") + 1);
    }

    Optional<Plugin> findProductPlugin() {
        List plugins = this.project.getBuildPlugins();
        if (plugins == null) {
            return Optional.empty();
        }
        ImmutableList possiblePluginTypes = ImmutableList.builder().addAll((Iterable)ProductHandlerFactory.getIds()).add((Object)"amps").build();
        return plugins.stream().filter(arg_0 -> AbstractAmpsDispatcherMojo.lambda$findProductPlugin$3((List)possiblePluginTypes, arg_0)).findFirst();
    }

    private static /* synthetic */ boolean lambda$findProductPlugin$3(List possiblePluginTypes, Plugin pomPlugin) {
        return "com.atlassian.maven.plugins".equals(pomPlugin.getGroupId()) && possiblePluginTypes.stream().anyMatch(type -> (type + "-maven-plugin").equals(pomPlugin.getArtifactId()));
    }
}

