/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cloud.jenkins.tenantinfo;

import com.atlassian.jira.cloud.jenkins.tenantinfo.TenantInfo;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Optional;
import javax.inject.Inject;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudIdResolver {
    private final OkHttpClient httpClient;
    private final ObjectMapper objectMapper;
    private static final Logger log = LoggerFactory.getLogger(CloudIdResolver.class);
    public static final String TENANT_INFO_ENDPOINT = "/_edge/tenant_info";

    @Inject
    public CloudIdResolver(OkHttpClient httpClient, ObjectMapper objectMapper) {
        this.httpClient = httpClient;
        this.objectMapper = objectMapper;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<String> getCloudId(String jiraSiteUrl) {
        Request request = new Request.Builder().url(String.format("%s%s", jiraSiteUrl, TENANT_INFO_ENDPOINT)).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                log.warn(String.format("Error response code %d when retrieving tenant info for %s", response.code(), jiraSiteUrl));
                Optional<String> optional = Optional.empty();
                return optional;
            }
            if (response.body() == null) {
                log.warn(String.format("Empty response when retrieving tenant info for %s", jiraSiteUrl));
                Optional<String> optional = Optional.empty();
                return optional;
            }
            TenantInfo tenantInfo = (TenantInfo)this.objectMapper.readValue(response.body().bytes(), TenantInfo.class);
            Optional<String> optional = Optional.of(tenantInfo.getCloudId());
            return optional;
        }
        catch (JsonParseException | JsonMappingException e) {
            log.error("Invalid JSON when retrieving tenant info for " + jiraSiteUrl, e);
            return Optional.empty();
        }
        catch (IOException e) {
            log.error("Server exception when retrieving tenant info for " + jiraSiteUrl, (Throwable)e);
            return Optional.empty();
        }
    }
}

