/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cloud.jenkins.provider;

import com.atlassian.jira.cloud.jenkins.Config;
import com.google.inject.Provides;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import io.github.resilience4j.ratelimiter.RequestNotPermitted;
import java.io.IOException;
import java.time.Duration;
import java.util.function.Predicate;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientProvider {
    private static final String USER_AGENT = "atlassian-jira-software-cloud-plugin";
    private static final Logger log = LoggerFactory.getLogger(HttpClientProvider.class);
    private final OkHttpClient httpClient;
    private final Predicate<Response> serverInternalPredicate = response -> response.code() >= 500;
    private final Predicate<Response> notFoudPredicate = response -> response.code() == 404 && response.request().url().toString().endsWith("gating-status");

    public HttpClientProvider() {
        RateLimiterRegistry rateLimiterRegistry = Config.RATE_LIMITER_REGISTRY;
        this.httpClient = new OkHttpClient.Builder().connectTimeout(Duration.ofMillis(5000L)).readTimeout(Duration.ofMillis(5000L)).writeTimeout(Duration.ofMillis(5000L)).addInterceptor(this.userAgentInterceptor()).addInterceptor(this.retryInterceptor()).addInterceptor(this.gateRetryInterceptor()).addInterceptor(this.rateLimiterInterceptor(rateLimiterRegistry)).build();
    }

    private Interceptor rateLimiterInterceptor(RateLimiterRegistry rateLimiterRegistry) {
        return chain -> {
            Request request = chain.request();
            String clientId = (String)request.tag(String.class);
            if (clientId != null) {
                RateLimiter rateLimiter = rateLimiterRegistry.rateLimiter(clientId, "atl");
                try {
                    return (Response)rateLimiter.executeCallable(() -> chain.proceed(request));
                }
                catch (Exception e) {
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    if (e instanceof RequestNotPermitted) {
                        throw (RequestNotPermitted)e;
                    }
                    throw new RuntimeException(e);
                }
            }
            return chain.proceed(request);
        };
    }

    private Interceptor gateRetryInterceptor() {
        return chain -> {
            Request request = chain.request();
            Response response = chain.proceed(request);
            response = this.performRetry(chain, request, response, this.notFoudPredicate);
            return response;
        };
    }

    private Interceptor retryInterceptor() {
        return chain -> {
            Request request = chain.request();
            Response response = chain.proceed(request);
            response = this.performRetry(chain, request, response, this.serverInternalPredicate);
            return response;
        };
    }

    private Interceptor userAgentInterceptor() {
        return chain -> {
            Request originalRequest = chain.request();
            Request userAgentRequest = originalRequest.newBuilder().header("User-Agent", USER_AGENT).build();
            return chain.proceed(userAgentRequest);
        };
    }

    private Response performRetry(Interceptor.Chain chain, Request request, Response originalResponse, Predicate<Response> retryPredicate) throws IOException {
        Response response = originalResponse;
        int MAX_RETRIES = 3;
        for (int currentAttempt = 1; retryPredicate.test(response) && currentAttempt <= 3; ++currentAttempt) {
            log.warn(String.format("Received %d for request to %s. Retry attempt %d of %d.", response.code(), response.request().url(), currentAttempt, 3));
            response.close();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                log.error("Retry delay interrupted: " + e.getMessage());
                Thread.currentThread().interrupt();
            }
            response = chain.proceed(request);
        }
        return response;
    }

    @Provides
    public OkHttpClient httpClient() {
        return this.httpClient;
    }
}

