/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cloud.jenkins.deploymentinfo.service;

import com.atlassian.jira.cloud.jenkins.auth.AccessTokenRetriever;
import com.atlassian.jira.cloud.jenkins.common.client.JiraApi;
import com.atlassian.jira.cloud.jenkins.common.client.PostUpdateResult;
import com.atlassian.jira.cloud.jenkins.common.config.JiraSiteConfigRetriever;
import com.atlassian.jira.cloud.jenkins.common.model.AppCredential;
import com.atlassian.jira.cloud.jenkins.common.response.JiraCommonResponse;
import com.atlassian.jira.cloud.jenkins.common.response.JiraSendInfoResponse;
import com.atlassian.jira.cloud.jenkins.common.service.IssueKeyExtractor;
import com.atlassian.jira.cloud.jenkins.config.JiraCloudSiteConfig;
import com.atlassian.jira.cloud.jenkins.deploymentinfo.client.DeploymentPayloadBuilder;
import com.atlassian.jira.cloud.jenkins.deploymentinfo.client.model.Association;
import com.atlassian.jira.cloud.jenkins.deploymentinfo.client.model.AssociationType;
import com.atlassian.jira.cloud.jenkins.deploymentinfo.client.model.Command;
import com.atlassian.jira.cloud.jenkins.deploymentinfo.client.model.DeploymentApiResponse;
import com.atlassian.jira.cloud.jenkins.deploymentinfo.client.model.Deployments;
import com.atlassian.jira.cloud.jenkins.deploymentinfo.client.model.Environment;
import com.atlassian.jira.cloud.jenkins.deploymentinfo.service.EnvironmentValidator;
import com.atlassian.jira.cloud.jenkins.deploymentinfo.service.JiraDeploymentInfoRequest;
import com.atlassian.jira.cloud.jenkins.deploymentinfo.service.JiraDeploymentInfoResponse;
import com.atlassian.jira.cloud.jenkins.deploymentinfo.service.JiraDeploymentInfoSender;
import com.atlassian.jira.cloud.jenkins.tenantinfo.CloudIdResolver;
import com.atlassian.jira.cloud.jenkins.util.JenkinsToJiraStatus;
import com.atlassian.jira.cloud.jenkins.util.RunWrapperProvider;
import com.atlassian.jira.cloud.jenkins.util.SecretRetriever;
import com.atlassian.jira.cloud.jenkins.util.StateValidator;
import com.google.common.collect.ImmutableList;
import hudson.model.Result;
import hudson.model.Run;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.support.steps.build.RunWrapper;

public class JiraDeploymentInfoSenderImpl
implements JiraDeploymentInfoSender {
    private static final String HTTPS_PROTOCOL = "https://";
    private static final Function<WorkflowRun, String> getJenkinsBuildStatus = run -> Optional.ofNullable(run.getResult()).map(Result::toString).orElseGet(() -> ((Result)Result.SUCCESS).toString());
    private final JiraSiteConfigRetriever siteConfigRetriever;
    private final SecretRetriever secretRetriever;
    private final CloudIdResolver cloudIdResolver;
    private final AccessTokenRetriever accessTokenRetriever;
    private final JiraApi deploymentsApi;
    private final RunWrapperProvider runWrapperProvider;
    private final IssueKeyExtractor issueKeyExtractor;

    public JiraDeploymentInfoSenderImpl(JiraSiteConfigRetriever siteConfigRetriever, SecretRetriever secretRetriever, CloudIdResolver cloudIdResolver, AccessTokenRetriever accessTokenRetriever, JiraApi jiraApi, IssueKeyExtractor issueKeyExtractor, RunWrapperProvider runWrapperProvider) {
        this.siteConfigRetriever = Objects.requireNonNull(siteConfigRetriever);
        this.secretRetriever = Objects.requireNonNull(secretRetriever);
        this.cloudIdResolver = Objects.requireNonNull(cloudIdResolver);
        this.accessTokenRetriever = Objects.requireNonNull(accessTokenRetriever);
        this.deploymentsApi = Objects.requireNonNull(jiraApi);
        this.runWrapperProvider = Objects.requireNonNull(runWrapperProvider);
        this.issueKeyExtractor = Objects.requireNonNull(issueKeyExtractor);
    }

    @Override
    public JiraSendInfoResponse sendDeploymentInfo(JiraDeploymentInfoRequest request) {
        String jiraSite = request.getSite();
        WorkflowRun deployment = request.getDeployment();
        Set<String> serviceIds = request.getServiceIds();
        Boolean enableGating = request.getEnableGating();
        Set<String> requestIssueKeys = request.getIssueKeys();
        Optional<JiraCloudSiteConfig> maybeSiteConfig = this.getSiteConfigFor(jiraSite);
        if (!maybeSiteConfig.isPresent()) {
            return JiraCommonResponse.failureSiteConfigNotFound(jiraSite);
        }
        String resolvedSiteConfig = maybeSiteConfig.get().getSite();
        JiraCloudSiteConfig siteConfig = maybeSiteConfig.get();
        Optional<String> maybeSecret = this.getSecretFor(siteConfig.getCredentialsId());
        if (!maybeSecret.isPresent()) {
            return JiraCommonResponse.failureSecretNotFound(resolvedSiteConfig);
        }
        Environment environment = this.buildEnvironment(request);
        List<String> errorMessages = EnvironmentValidator.validate(environment);
        if (!errorMessages.isEmpty()) {
            return JiraDeploymentInfoResponse.failureEnvironmentInvalid(jiraSite, errorMessages);
        }
        String deploymentState = this.getDeploymentState(deployment, request.getState());
        errorMessages = StateValidator.validate(deploymentState);
        if (!errorMessages.isEmpty()) {
            return JiraDeploymentInfoResponse.failureStateInvalid(errorMessages);
        }
        Set<String> issueKeys = requestIssueKeys.isEmpty() ? this.issueKeyExtractor.extractIssueKeys(deployment) : requestIssueKeys;
        if (issueKeys.isEmpty() && serviceIds.isEmpty()) {
            return JiraDeploymentInfoResponse.skippedIssueKeysNotFoundAndServiceIdsAreEmpty(resolvedSiteConfig);
        }
        Set<Association> associations = this.buildAssociations(issueKeys, serviceIds);
        Optional<String> maybeCloudId = this.getCloudIdFor(resolvedSiteConfig);
        if (!maybeCloudId.isPresent()) {
            return JiraCommonResponse.failureSiteNotFound(resolvedSiteConfig);
        }
        Optional<String> maybeAccessToken = this.getAccessTokenFor(siteConfig, maybeSecret.get());
        if (!maybeAccessToken.isPresent()) {
            return JiraCommonResponse.failureAccessToken(resolvedSiteConfig);
        }
        List<Command> commands = this.buildCommands(enableGating);
        Deployments deploymentInfo = this.createJiraDeploymentInfo((Run)deployment, environment, associations, deploymentState, commands);
        PostUpdateResult<DeploymentApiResponse> postUpdateResult = this.sendDeploymentInfo(maybeCloudId.get(), maybeAccessToken.get(), resolvedSiteConfig, deploymentInfo);
        if (postUpdateResult.getResponseEntity().isPresent()) {
            return this.handleDeploymentApiResponse(resolvedSiteConfig, postUpdateResult.getResponseEntity().get());
        }
        String errorMessage = postUpdateResult.getErrorMessage().orElse("");
        return this.handleDeploymentApiError(resolvedSiteConfig, errorMessage);
    }

    private Optional<JiraCloudSiteConfig> getSiteConfigFor(@Nullable String jiraSite) {
        return this.siteConfigRetriever.getJiraSiteConfig(jiraSite);
    }

    private Optional<String> getCloudIdFor(String jiraSite) {
        String jiraSiteUrl = HTTPS_PROTOCOL + jiraSite;
        return this.cloudIdResolver.getCloudId(jiraSiteUrl);
    }

    private Optional<String> getAccessTokenFor(JiraCloudSiteConfig siteConfig, String secret) {
        AppCredential appCredential = new AppCredential(siteConfig.getClientId(), secret);
        return this.accessTokenRetriever.getAccessToken(appCredential);
    }

    private Optional<String> getSecretFor(String credentialsId) {
        return this.secretRetriever.getSecretFor(credentialsId);
    }

    private Deployments createJiraDeploymentInfo(Run build, Environment environment, Set<Association> associations, String state, List<Command> commands) {
        RunWrapper buildWrapper = this.runWrapperProvider.getWrapper(build);
        return DeploymentPayloadBuilder.getDeploymentInfo(buildWrapper, environment, associations, state, commands);
    }

    private PostUpdateResult<DeploymentApiResponse> sendDeploymentInfo(String cloudId, String accessToken, String jiraSite, Deployments deploymentInfo) {
        return this.deploymentsApi.postUpdate(cloudId, accessToken, jiraSite, deploymentInfo, DeploymentApiResponse.class);
    }

    private JiraSendInfoResponse handleDeploymentApiResponse(String jiraSite, DeploymentApiResponse response) {
        if (!response.getAcceptedDeployments().isEmpty()) {
            return JiraDeploymentInfoResponse.successDeploymentAccepted(jiraSite, response);
        }
        if (!response.getUnknownAssociations().isEmpty()) {
            return JiraDeploymentInfoResponse.failureUnknownAssociations(jiraSite, response);
        }
        if (!response.getRejectedDeployments().isEmpty()) {
            return JiraDeploymentInfoResponse.failureDeploymentRejected(jiraSite, response);
        }
        return JiraDeploymentInfoResponse.failureUnexpectedResponse();
    }

    private JiraDeploymentInfoResponse handleDeploymentApiError(String jiraSite, String errorMessage) {
        return JiraDeploymentInfoResponse.failureDeploymentsApiResponse(jiraSite, errorMessage);
    }

    private Environment buildEnvironment(JiraDeploymentInfoRequest request) {
        String environmentType = StringUtils.isNotBlank((String)request.getEnvironmentType()) ? request.getEnvironmentType() : "unmapped";
        return Environment.builder().withId(request.getEnvironmentId()).withDisplayName(request.getEnvironmentName()).withType(environmentType).build();
    }

    private String getDeploymentState(WorkflowRun build, @Nullable String state) {
        return Optional.ofNullable(state).orElseGet(() -> JenkinsToJiraStatus.getStatus(getJenkinsBuildStatus.apply(build)));
    }

    private Set<Association> buildAssociations(Set<String> issueKeys, Set<String> serviceIds) {
        HashSet<Association> associations = new HashSet<Association>();
        if (!issueKeys.isEmpty()) {
            associations.add(Association.builder().withAssociationType(AssociationType.ISSUE_KEYS).withValues(issueKeys).build());
        }
        if (!serviceIds.isEmpty()) {
            associations.add(Association.builder().withAssociationType(AssociationType.SERVICE_ID_OR_KEYS).withValues(serviceIds).build());
        }
        return associations;
    }

    private List<Command> buildCommands(Boolean enableGating) {
        ImmutableList.Builder commandsBuilder = ImmutableList.builder();
        if (enableGating.booleanValue()) {
            commandsBuilder.add((Object)new Command("initiate_deployment_gating"));
        }
        return commandsBuilder.build();
    }
}

