/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cloud.jenkins.deploymentinfo.service;

import com.atlassian.jira.cloud.jenkins.common.model.IssueKey;
import com.atlassian.jira.cloud.jenkins.common.service.IssueKeyExtractor;
import com.atlassian.jira.cloud.jenkins.util.IssueKeyStringExtractor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.git.GitChangeSet;
import hudson.scm.ChangeLogSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChangeLogIssueKeyExtractor
implements IssueKeyExtractor {
    private static final Logger log = LoggerFactory.getLogger(ChangeLogIssueKeyExtractor.class);

    @Override
    public Set<String> extractIssueKeys(WorkflowRun workflowRun) {
        HashSet<IssueKey> allIssueKeys = new HashSet<IssueKey>();
        ArrayList changeSets = new ArrayList(workflowRun.getChangeSets());
        WorkflowRun previous = workflowRun.getPreviousBuild();
        while (Objects.nonNull(previous) && !this.isBuildSuccessful(previous)) {
            log.info("Extract issue keys from build: " + previous.getNumber());
            changeSets.addAll(previous.getChangeSets());
            previous = previous.getPreviousBuild();
        }
        block1: for (ChangeLogSet changeSet : changeSets) {
            Object[] changeSetEntries;
            for (Object item : changeSetEntries = changeSet.getItems()) {
                ChangeLogSet.Entry changeSetEntry = (ChangeLogSet.Entry)item;
                if (changeSetEntry instanceof GitChangeSet) {
                    allIssueKeys.addAll(IssueKeyStringExtractor.extractIssueKeys(((GitChangeSet)changeSetEntry).getComment()));
                }
                allIssueKeys.addAll(IssueKeyStringExtractor.extractIssueKeys(changeSetEntry.getMsg()));
                if (allIssueKeys.size() >= ISSUE_KEY_MAX_LIMIT) continue block1;
            }
        }
        return allIssueKeys.stream().limit(ISSUE_KEY_MAX_LIMIT.intValue()).map(IssueKey::toString).collect(Collectors.toSet());
    }

    private boolean isBuildSuccessful(@CheckForNull WorkflowRun workflowRun) {
        return Optional.ofNullable(workflowRun).map(Run::getResult).map(Result::toString).map(Result.SUCCESS.toString()::equals).orElse(true);
    }
}

