/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cloud.jenkins.deploymentinfo.pipeline;

import com.atlassian.jira.cloud.jenkins.Messages;
import com.atlassian.jira.cloud.jenkins.common.factory.JiraSenderFactory;
import com.atlassian.jira.cloud.jenkins.common.response.JiraSendInfoResponse;
import com.atlassian.jira.cloud.jenkins.config.JiraCloudPluginConfig;
import com.atlassian.jira.cloud.jenkins.config.JiraCloudSiteConfig;
import com.atlassian.jira.cloud.jenkins.deploymentinfo.client.model.State;
import com.atlassian.jira.cloud.jenkins.deploymentinfo.service.JiraDeploymentInfoRequest;
import com.google.common.collect.ImmutableSet;
import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class JiraSendDeploymentInfoStep
extends Step
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String site;
    private String environmentId;
    private String environmentName;
    private String environmentType;
    private String state;
    private List<String> serviceIds = new ArrayList<String>();
    private Boolean enableGating = Boolean.FALSE;
    private List<String> issueKeys = new ArrayList<String>();

    @DataBoundConstructor
    public JiraSendDeploymentInfoStep(String environmentId, String environmentName, String environmentType) {
        this.environmentId = environmentId;
        this.environmentName = environmentName;
        this.environmentType = environmentType;
    }

    public String getSite() {
        return this.site;
    }

    @DataBoundSetter
    public void setSite(String site) {
        this.site = site;
    }

    public String getEnvironmentId() {
        return this.environmentId;
    }

    @DataBoundSetter
    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    @DataBoundSetter
    public void setEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
    }

    public String getEnvironmentType() {
        return this.environmentType;
    }

    @DataBoundSetter
    public void setEnvironmentType(String environmentType) {
        this.environmentType = environmentType;
    }

    @DataBoundSetter
    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public StepExecution start(StepContext stepContext) throws Exception {
        return new JiraSendDeploymentInfoStepExecution(stepContext, this);
    }

    public List<String> getServiceIds() {
        return this.serviceIds;
    }

    @DataBoundSetter
    public void setServiceIds(List<String> serviceIds) {
        this.serviceIds = serviceIds;
    }

    public Boolean getEnableGating() {
        return this.enableGating;
    }

    public List<String> getIssueKeys() {
        return this.issueKeys;
    }

    @DataBoundSetter
    public void setEnableGating(Boolean enableGating) {
        this.enableGating = enableGating;
    }

    @DataBoundSetter
    public void setIssueKeys(List<String> issueKeys) {
        this.issueKeys = issueKeys;
    }

    public static class JiraSendDeploymentInfoStepExecution
    extends SynchronousNonBlockingStepExecution<JiraSendInfoResponse> {
        private final JiraSendDeploymentInfoStep step;

        public JiraSendDeploymentInfoStepExecution(StepContext context, JiraSendDeploymentInfoStep step) {
            super(context);
            this.step = step;
        }

        protected JiraSendInfoResponse run() throws Exception {
            TaskListener taskListener = (TaskListener)this.getContext().get(TaskListener.class);
            WorkflowRun workflowRun = (WorkflowRun)this.getContext().get(WorkflowRun.class);
            ImmutableSet serviceIds = ImmutableSet.copyOf(this.step.getServiceIds());
            ImmutableSet issueKeys = ImmutableSet.copyOf(this.step.getIssueKeys());
            JiraDeploymentInfoRequest request = new JiraDeploymentInfoRequest(this.step.getSite(), this.step.getEnvironmentId(), this.step.getEnvironmentName(), this.step.getEnvironmentType(), this.step.getState(), (Set<String>)serviceIds, this.step.getEnableGating(), (Set<String>)issueKeys, workflowRun);
            JiraSendInfoResponse response = JiraSenderFactory.getInstance().getJiraDeploymentInfoSender().sendDeploymentInfo(request);
            this.logResult(taskListener, response);
            return response;
        }

        private void logResult(TaskListener taskListener, JiraSendInfoResponse response) {
            taskListener.getLogger().println("jiraSendDeploymentInfo: " + (Object)((Object)response.getStatus()) + ": " + response.getMessage());
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        @Inject
        private transient JiraCloudPluginConfig globalConfig;

        public Set<Class<?>> getRequiredContext() {
            return ImmutableSet.of(TaskListener.class, Run.class);
        }

        public String getFunctionName() {
            return "jiraSendDeploymentInfo";
        }

        public String getDisplayName() {
            return Messages.JiraSendDeploymentInfoStep_DescriptorImpl_DisplayName();
        }

        public ListBoxModel doFillSiteItems() {
            ListBoxModel items = new ListBoxModel();
            List<JiraCloudSiteConfig> siteList = this.globalConfig.getSites();
            for (JiraCloudSiteConfig siteConfig : siteList) {
                items.add(siteConfig.getSite(), siteConfig.getSite());
            }
            return items;
        }

        public ListBoxModel doFillEnvironmentTypeItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("development", "development");
            items.add("testing", "testing");
            items.add("staging", "staging");
            items.add("production", "production");
            return items;
        }

        public ListBoxModel doFillStateItems() {
            ListBoxModel items = new ListBoxModel();
            for (String state : State.ALLOWED_STATES) {
                items.add(state, state);
            }
            return items;
        }
    }
}

