/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cloud.jenkins.deploymentinfo.client.model;

import com.atlassian.jira.cloud.jenkins.deploymentinfo.client.model.AssociationType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Set;

public class Association {
    private final AssociationType associationType;
    private final Set<String> values;

    @JsonCreator
    public Association(@JsonProperty(value="type") AssociationType associationType, @JsonProperty(value="values") Set<String> values) {
        this.associationType = associationType;
        this.values = values;
    }

    public AssociationType getAssociationType() {
        return this.associationType;
    }

    public Set<String> getValues() {
        return this.values;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Association that = (Association)o;
        return this.associationType == that.associationType && this.values.equals(that.values);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.associationType, this.values});
    }

    public String toString() {
        return "Association{associationType=" + this.associationType.getValue() + ", values=" + this.values + '}';
    }

    public static class Builder {
        private AssociationType associationType;
        private Set<String> values;

        public Builder withAssociationType(AssociationType associationsType) {
            this.associationType = associationsType;
            return this;
        }

        public Builder withValues(Set<String> values) {
            this.values = values;
            return this;
        }

        public Association build() {
            return new Association(this.associationType, this.values);
        }
    }
}

