/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cloud.jenkins.deploymentinfo.client;

import com.atlassian.jira.cloud.jenkins.deploymentinfo.client.model.Association;
import com.atlassian.jira.cloud.jenkins.deploymentinfo.client.model.Command;
import com.atlassian.jira.cloud.jenkins.deploymentinfo.client.model.Deployments;
import com.atlassian.jira.cloud.jenkins.deploymentinfo.client.model.Environment;
import com.atlassian.jira.cloud.jenkins.deploymentinfo.client.model.JiraDeploymentInfo;
import com.atlassian.jira.cloud.jenkins.deploymentinfo.client.model.Pipeline;
import hudson.AbortException;
import hudson.model.Run;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jenkinsci.plugins.workflow.support.steps.build.RunWrapper;

public final class DeploymentPayloadBuilder {
    public static Deployments getDeploymentInfo(RunWrapper runWrapper, Environment environment, Set<Association> associations, String state, List<Command> commands) {
        try {
            return new Deployments(JiraDeploymentInfo.builder().withDeploymentSequenceNumber(runWrapper.getNumber()).withUpdateSequenceNumber(Instant.now().getEpochSecond()).withAssociations(associations).withDisplayName(runWrapper.getDisplayName()).withUrl(runWrapper.getAbsoluteUrl()).withDescription(runWrapper.getDisplayName()).withLastUpdated(Instant.now().toString()).withLabel(runWrapper.getDisplayName()).withState(state).withPipeline(DeploymentPayloadBuilder.getPipeline(runWrapper)).withEnvironment(environment).withCommands(commands).build());
        }
        catch (AbortException e) {
            throw new RuntimeException(e);
        }
    }

    private static Pipeline getPipeline(RunWrapper runWrapper) throws AbortException {
        Optional<Run> build = Optional.ofNullable(runWrapper.getRawBuild());
        return Pipeline.builder().withId(runWrapper.getFullProjectName()).withDisplayName(runWrapper.getFullProjectName()).withUrl(build.map(b -> b.getParent().getAbsoluteUrl()).orElse(runWrapper.getAbsoluteUrl())).build();
    }
}

