/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cloud.jenkins.config;

import com.atlassian.jira.cloud.jenkins.auth.AccessTokenRetriever;
import com.atlassian.jira.cloud.jenkins.common.model.AppCredential;
import com.atlassian.jira.cloud.jenkins.tenantinfo.CloudIdResolver;
import com.atlassian.jira.cloud.jenkins.util.SecretRetriever;
import com.atlassian.jira.cloud.jenkins.util.SiteValidator;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class JiraCloudSiteConfig
extends AbstractDescribableImpl<JiraCloudSiteConfig> {
    public static final String DEFAULT_SITE = "sitename.atlassian.net";
    private final String site;
    private final String clientId;
    private final String credentialsId;

    @DataBoundConstructor
    public JiraCloudSiteConfig(String site, String clientId, String credentialsId) {
        this.site = Objects.requireNonNull(site);
        this.clientId = Objects.requireNonNull(clientId);
        this.credentialsId = Objects.requireNonNull(credentialsId);
    }

    public String getSite() {
        return this.site;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<JiraCloudSiteConfig> {
        private transient AccessTokenRetriever accessTokenRetriever;
        private transient SecretRetriever secretRetriever;
        private transient CloudIdResolver cloudIdResolver;

        @Inject
        public void setAccessTokenRetriever(AccessTokenRetriever accessTokenRetriever) {
            this.accessTokenRetriever = accessTokenRetriever;
        }

        @Inject
        public void setSecretRetriever(SecretRetriever secretRetriever) {
            this.secretRetriever = secretRetriever;
        }

        @Inject
        public void setCloudIdResolver(CloudIdResolver cloudIdResolver) {
            this.cloudIdResolver = cloudIdResolver;
        }

        public FormValidation doCheckSite(@QueryParameter String value) {
            if (StringUtils.isEmpty((String)value)) {
                return FormValidation.error((String)"Site name can't be empty. Paste your Jira Cloud site name here.");
            }
            if (!SiteValidator.isValid(value)) {
                return FormValidation.error((String)"Site name is invalid. Paste a valid site name, e.g. sitename.atlassian.net.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckClientId(@QueryParameter String value) {
            if (StringUtils.isEmpty((String)value)) {
                return FormValidation.error((String)"Client ID can\u2019t be blank. Paste it from your OAuth credentials in Jira Cloud.");
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillCredentialsIdItems(@QueryParameter String credentialsId) {
            Jenkins instance = Jenkins.get();
            if (!instance.hasPermission(Jenkins.ADMINISTER)) {
                return new StandardListBoxModel().includeCurrentValue(credentialsId);
            }
            return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM, (ItemGroup)instance, StringCredentials.class, URIRequirementBuilder.fromUri((String)"https://api.atlassian.com").build(), CredentialsMatchers.always());
        }

        @RequirePOST
        @Restricted(value={DoNotUse.class})
        public FormValidation doTestConnection(@QueryParameter String site, @QueryParameter String clientId, @QueryParameter String credentialsId) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            Optional<String> maybeCloudId = this.cloudIdResolver.getCloudId("https://" + site);
            if (!maybeCloudId.isPresent()) {
                return FormValidation.error((String)("Failed to resolve Jira Cloud site: " + site));
            }
            Optional<String> maybeSecret = this.secretRetriever.getSecretFor(credentialsId);
            if (!maybeSecret.isPresent()) {
                return FormValidation.error((String)"Failed to retrieve secret");
            }
            AppCredential appCredential = new AppCredential(clientId, maybeSecret.get());
            Optional<String> accessToken = this.accessTokenRetriever.getAccessToken(appCredential);
            if (!accessToken.isPresent()) {
                return FormValidation.error((String)"Failed to validate site credentials");
            }
            return FormValidation.ok((String)"Successfully validated site credentials");
        }

        public String getDisplayName() {
            return "Jira Cloud Site";
        }
    }
}

