/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cloud.jenkins.common.client;

import com.atlassian.jira.cloud.jenkins.common.client.ApiUpdateFailedException;
import com.atlassian.jira.cloud.jenkins.common.client.JiraRequest;
import com.atlassian.jira.cloud.jenkins.common.client.PostUpdateResult;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import io.github.resilience4j.ratelimiter.RequestNotPermitted;
import java.io.IOException;
import java.io.NotSerializableException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.lang.text.StrSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraApi {
    private static final Logger log = LoggerFactory.getLogger(JiraApi.class);
    private static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");
    private final OkHttpClient httpClient;
    private final ObjectMapper objectMapper;
    private String apiEndpoint;

    @Inject
    public JiraApi(OkHttpClient httpClient, ObjectMapper objectMapper, String apiUrl) {
        this.httpClient = Objects.requireNonNull(httpClient);
        this.objectMapper = Objects.requireNonNull(objectMapper);
        this.apiEndpoint = apiUrl;
    }

    public <ResponseEntity> PostUpdateResult<ResponseEntity> postUpdate(String cloudId, String accessToken, String clientId, JiraRequest jiraRequest, Class<ResponseEntity> responseClass) {
        try {
            String requestPayload = this.objectMapper.writeValueAsString((Object)jiraRequest);
            Request request = this.getRequest(cloudId, accessToken, requestPayload, clientId);
            Response response = this.httpClient.newCall(request).execute();
            this.checkForErrorResponse(response);
            ResponseEntity responseEntity = this.handleResponseBody(response, responseClass);
            return new PostUpdateResult<ResponseEntity>(responseEntity);
        }
        catch (NotSerializableException e) {
            return this.handleError(String.format("Invalid JSON payload: %s", e.getMessage()));
        }
        catch (JsonProcessingException e) {
            return this.handleError(String.format("Unable to create the request payload: %s", e.getMessage()));
        }
        catch (IOException e) {
            return this.handleError(String.format("Server exception when submitting update to Jira: %s", e.getMessage()));
        }
        catch (ApiUpdateFailedException e) {
            return this.handleError(e.getMessage());
        }
        catch (RequestNotPermitted e) {
            return this.handleError("Your OAuth client reached Jira's limits " + e.getMessage());
        }
        catch (Exception e) {
            return this.handleError(String.format("Unexpected error when submitting update to Jira: %s", e.getMessage()));
        }
    }

    public <ResponseEntity> PostUpdateResult<ResponseEntity> getResult(String accessToken, Map<String, String> pathParams, String clientId, Class<ResponseEntity> responseClass) {
        try {
            Request request = this.getRequest(accessToken, pathParams, clientId);
            Response response = this.httpClient.newCall(request).execute();
            this.checkForErrorResponse(response);
            ResponseEntity responseEntity = this.handleResponseBody(response, responseClass);
            return new PostUpdateResult<ResponseEntity>(responseEntity);
        }
        catch (NotSerializableException e) {
            return this.handleError(String.format("Invalid JSON payload: %s", e.getMessage()));
        }
        catch (JsonProcessingException e) {
            return this.handleError(String.format("Unable to create the request payload: %s", e.getMessage()));
        }
        catch (IOException e) {
            return this.handleError(String.format("Server exception when submitting update to Jira: %s", e.getMessage()));
        }
        catch (ApiUpdateFailedException e) {
            return this.handleError(e.getMessage());
        }
        catch (RequestNotPermitted e) {
            return this.handleError("Your OAuth client reached Jira's limits " + e.getMessage());
        }
        catch (Exception e) {
            return this.handleError(String.format("Unexpected error when submitting update to Jira: %s", e.getMessage()));
        }
    }

    private void checkForErrorResponse(Response response) throws IOException {
        if (!response.isSuccessful()) {
            String message = String.format("Error response code %d when submitting update to Jira", response.code());
            ResponseBody responseBody = response.body();
            if (responseBody != null) {
                log.error(String.format("Error response body when submitting update to Jira: %s", responseBody.string()));
                responseBody.close();
            }
            throw new ApiUpdateFailedException(message);
        }
    }

    private <ResponseEntity> ResponseEntity handleResponseBody(Response response, Class<ResponseEntity> responseClass) throws IOException {
        if (response.body() == null) {
            String message = "Empty response body when submitting update to Jira";
            throw new ApiUpdateFailedException("Empty response body when submitting update to Jira");
        }
        return (ResponseEntity)this.objectMapper.readValue(response.body().bytes(), this.objectMapper.getTypeFactory().constructType(responseClass));
    }

    @VisibleForTesting
    void setApiEndpoint(String apiEndpoint) {
        this.apiEndpoint = apiEndpoint;
    }

    private Request getRequest(String cloudId, String accessToken, String requestPayload, String clientId) {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)requestPayload);
        return new Request.Builder().url(String.format(this.apiEndpoint, cloudId)).addHeader("Authorization", "Bearer " + accessToken).tag(String.class, (Object)clientId).post(body).build();
    }

    private Request getRequest(String accessToken, Map<String, String> pathParams, String clientId) {
        HttpUrl url = HttpUrl.parse((String)this.apiEndpoint);
        List segments = url.pathSegments();
        HttpUrl.Builder builder = url.newBuilder();
        for (int i = 0; i < segments.size(); ++i) {
            builder.setPathSegment(i, StrSubstitutor.replace(segments.get(i), pathParams));
        }
        return new Request.Builder().url(builder.build()).addHeader("Authorization", "Bearer " + accessToken).tag(String.class, (Object)clientId).get().build();
    }

    private <T> PostUpdateResult<T> handleError(String errorMessage) {
        return new PostUpdateResult(errorMessage);
    }
}

