/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cloud.jenkins.checkgatingstatus.service;

import com.atlassian.jira.cloud.jenkins.auth.AccessTokenRetriever;
import com.atlassian.jira.cloud.jenkins.checkgatingstatus.client.model.GatingStatusResponse;
import com.atlassian.jira.cloud.jenkins.checkgatingstatus.service.GatingStatusRequest;
import com.atlassian.jira.cloud.jenkins.checkgatingstatus.service.JiraGatingStatusResponse;
import com.atlassian.jira.cloud.jenkins.checkgatingstatus.service.JiraGatingStatusRetriever;
import com.atlassian.jira.cloud.jenkins.common.client.JiraApi;
import com.atlassian.jira.cloud.jenkins.common.client.PostUpdateResult;
import com.atlassian.jira.cloud.jenkins.common.config.JiraSiteConfigRetriever;
import com.atlassian.jira.cloud.jenkins.common.model.AppCredential;
import com.atlassian.jira.cloud.jenkins.common.response.JiraCommonResponse;
import com.atlassian.jira.cloud.jenkins.config.JiraCloudSiteConfig;
import com.atlassian.jira.cloud.jenkins.tenantinfo.CloudIdResolver;
import com.atlassian.jira.cloud.jenkins.util.SecretRetriever;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

public class JiraGatingStatusRetrieverImpl
implements JiraGatingStatusRetriever {
    private static final String HTTPS_PROTOCOL = "https://";
    private final JiraSiteConfigRetriever siteConfigRetriever;
    private final SecretRetriever secretRetriever;
    private final CloudIdResolver cloudIdResolver;
    private final AccessTokenRetriever accessTokenRetriever;
    private final JiraApi gatingApi;

    public JiraGatingStatusRetrieverImpl(JiraSiteConfigRetriever siteConfigRetriever, SecretRetriever secretRetriever, CloudIdResolver cloudIdResolver, AccessTokenRetriever accessTokenRetriever, JiraApi gatingApi) {
        this.siteConfigRetriever = siteConfigRetriever;
        this.secretRetriever = secretRetriever;
        this.cloudIdResolver = cloudIdResolver;
        this.accessTokenRetriever = accessTokenRetriever;
        this.gatingApi = gatingApi;
    }

    @Override
    public JiraGatingStatusResponse getGatingStatus(GatingStatusRequest request) {
        String jiraSite = request.getSite();
        WorkflowRun run = request.getRun();
        Optional<JiraCloudSiteConfig> maybeSiteConfig = this.siteConfigRetriever.getJiraSiteConfig(jiraSite);
        if (!maybeSiteConfig.isPresent()) {
            return JiraGatingStatusResponse.of(JiraCommonResponse.failureSiteConfigNotFound(jiraSite));
        }
        String resolvedSiteConfig = maybeSiteConfig.get().getSite();
        JiraCloudSiteConfig siteConfig = maybeSiteConfig.get();
        Optional<String> maybeSecret = this.secretRetriever.getSecretFor(siteConfig.getCredentialsId());
        if (!maybeSecret.isPresent()) {
            return JiraGatingStatusResponse.of(JiraCommonResponse.failureSecretNotFound(resolvedSiteConfig));
        }
        Optional<String> maybeCloudId = this.cloudIdResolver.getCloudId(HTTPS_PROTOCOL + resolvedSiteConfig);
        if (!maybeCloudId.isPresent()) {
            return JiraGatingStatusResponse.of(JiraCommonResponse.failureSiteNotFound(resolvedSiteConfig));
        }
        String cloudId = maybeCloudId.get();
        AppCredential appCredential = new AppCredential(siteConfig.getClientId(), maybeSecret.get());
        Optional<String> maybeAccessToken = this.accessTokenRetriever.getAccessToken(appCredential);
        if (!maybeAccessToken.isPresent()) {
            return JiraGatingStatusResponse.of(JiraCommonResponse.failureAccessToken(resolvedSiteConfig));
        }
        ImmutableMap pathParams = ImmutableMap.builder().put((Object)"cloudId", (Object)cloudId).put((Object)"deploymentId", (Object)Integer.toString(run.getNumber())).put((Object)"pipelineId", (Object)((WorkflowJob)run.getParent()).getFullName()).put((Object)"environmentId", (Object)request.getEnvironmentId()).build();
        PostUpdateResult<GatingStatusResponse> result = this.gatingApi.getResult(maybeAccessToken.get(), (Map<String, String>)pathParams, siteConfig.getClientId(), GatingStatusResponse.class);
        if (result.getResponseEntity().isPresent()) {
            return JiraGatingStatusResponse.success(result.getResponseEntity().get());
        }
        String errorMessage = result.getErrorMessage().orElse("");
        return JiraGatingStatusResponse.failure(errorMessage);
    }
}

