/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cloud.jenkins.buildinfo.service;

import com.atlassian.jira.cloud.jenkins.Messages;
import com.atlassian.jira.cloud.jenkins.buildinfo.client.model.BuildApiResponse;
import com.atlassian.jira.cloud.jenkins.common.response.JiraSendInfoResponse;

public class JiraBuildInfoResponse
extends JiraSendInfoResponse {
    public JiraBuildInfoResponse(JiraSendInfoResponse.Status status, String message) {
        super(status, message);
    }

    public static JiraBuildInfoResponse successBuildAccepted(String jiraSite, BuildApiResponse response) {
        String message = Messages.JiraBuildInfoResponse_SUCCESS_BUILD_ACCEPTED(jiraSite, response.getAcceptedBuilds());
        return new JiraBuildInfoResponse(JiraSendInfoResponse.Status.SUCCESS_BUILD_ACCEPTED, message);
    }

    public static JiraBuildInfoResponse failureBuildRejected(String jiraSite, BuildApiResponse response) {
        String message = Messages.JiraBuildInfoResponse_FAILURE_BUILD_REJECTED(jiraSite, response.getRejectedBuilds());
        return new JiraBuildInfoResponse(JiraSendInfoResponse.Status.FAILURE_BUILD_REJECTED, message);
    }

    public static JiraBuildInfoResponse failureUnknownIssueKeys(String jiraSite, BuildApiResponse response) {
        String message = Messages.JiraBuildInfoResponse_FAILURE_UNKNOWN_ISSUE_KEYS(jiraSite, response.getUnknownIssueKeys());
        return new JiraBuildInfoResponse(JiraSendInfoResponse.Status.FAILURE_UNKNOWN_ISSUE_KEYS, message);
    }

    public static JiraBuildInfoResponse failureBuildsApiResponse(String jiraSite, String errorMessage) {
        String message = Messages.JiraBuildInfoResponse_FAILURE_BUILDS_API_RESPONSE(jiraSite, errorMessage);
        return new JiraBuildInfoResponse(JiraSendInfoResponse.Status.FAILURE_BUILDS_API_RESPONSE, message);
    }

    public static JiraBuildInfoResponse failureUnexpectedResponse() {
        String message = Messages.JiraBuildInfoResponse_FAILURE_UNEXPECTED_RESPONSE();
        return new JiraBuildInfoResponse(JiraSendInfoResponse.Status.FAILURE_UNEXPECTED_RESPONSE, message);
    }

    public static JiraBuildInfoResponse skippedIssueKeysNotFound() {
        String message = Messages.JiraBuildInfoResponse_SKIPPED_ISSUE_KEYS_NOT_FOUND();
        return new JiraBuildInfoResponse(JiraSendInfoResponse.Status.SKIPPED_ISSUE_KEYS_NOT_FOUND, message);
    }
}

