/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cloud.jenkins.buildinfo.client;

import com.atlassian.jira.cloud.jenkins.buildinfo.client.model.Builds;
import com.atlassian.jira.cloud.jenkins.buildinfo.client.model.JiraBuildInfo;
import com.atlassian.jira.cloud.jenkins.buildinfo.client.model.TestInfo;
import com.atlassian.jira.cloud.jenkins.util.JenkinsToJiraStatus;
import hudson.AbortException;
import hudson.tasks.junit.TestResultAction;
import java.time.Instant;
import java.util.Optional;
import java.util.Set;
import org.jenkinsci.plugins.workflow.support.steps.build.RunWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BuildPayloadBuilder {
    private static final Logger log = LoggerFactory.getLogger(BuildPayloadBuilder.class);

    public static Builds getBuildPayload(RunWrapper buildWrapper, Set<String> issueKeys) {
        try {
            TestInfo testInfo = Optional.ofNullable(buildWrapper.getRawBuild()).map(r -> (TestResultAction)r.getAction(TestResultAction.class)).map(a -> {
                TestInfo info = new TestInfo();
                info.setTotalNumber(a.getTotalCount());
                info.setNumberPassed(a.getTotalCount() - a.getFailCount() - a.getSkipCount());
                info.setNumberFailed(a.getFailCount());
                info.setNumberSkipped(a.getSkipCount());
                return info;
            }).orElse(null);
            return new Builds(JiraBuildInfo.builder().withPipelineId(buildWrapper.getFullProjectName()).withBuildNumber(buildWrapper.getNumber()).withDisplayName(buildWrapper.getFullProjectName()).withUpdateSequenceNumber(Instant.now().getEpochSecond()).withLabel(buildWrapper.getDisplayName()).withUrl(buildWrapper.getAbsoluteUrl()).withState(JenkinsToJiraStatus.getStatus(buildWrapper.getCurrentResult())).withLastUpdated(Instant.now().toString()).withIssueKeys(issueKeys).withTestInfo(testInfo).build());
        }
        catch (AbortException e) {
            throw new RuntimeException(e);
        }
    }
}

