// CHECKSTYLE:OFF

package com.atlassian.jira.cloud.jenkins;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code JiraBuildInfoResponse.SUCCESS_BUILD_ACCEPTED}: {@code
     * Successfully sent build information to Jira: {0}. Accepted builds:
     * {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Successfully sent build information to Jira: {0}. Accepted
     *     builds: {1}.}
     */
    public static String JiraBuildInfoResponse_SUCCESS_BUILD_ACCEPTED(Object arg0, Object arg1) {
        return holder.format("JiraBuildInfoResponse.SUCCESS_BUILD_ACCEPTED", arg0, arg1);
    }

    /**
     * Key {@code JiraBuildInfoResponse.SUCCESS_BUILD_ACCEPTED}: {@code
     * Successfully sent build information to Jira: {0}. Accepted builds:
     * {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Successfully sent build information to Jira: {0}. Accepted
     *     builds: {1}.}
     */
    public static Localizable _JiraBuildInfoResponse_SUCCESS_BUILD_ACCEPTED(Object arg0, Object arg1) {
        return new Localizable(holder, "JiraBuildInfoResponse.SUCCESS_BUILD_ACCEPTED", arg0, arg1);
    }

    /**
     * Key {@code JiraCheckGateStatusStep.DescriptorImpl.DisplayName}: {@code
     * Atlassian Jira Service Desk Software Cloud Jenkins Integration
     * (Deployment Gating)}.
     * 
     * @return
     *     {@code Atlassian Jira Service Desk Software Cloud Jenkins Integration
     *     (Deployment Gating)}
     */
    public static String JiraCheckGateStatusStep_DescriptorImpl_DisplayName() {
        return holder.format("JiraCheckGateStatusStep.DescriptorImpl.DisplayName");
    }

    /**
     * Key {@code JiraCheckGateStatusStep.DescriptorImpl.DisplayName}: {@code
     * Atlassian Jira Service Desk Software Cloud Jenkins Integration
     * (Deployment Gating)}.
     * 
     * @return
     *     {@code Atlassian Jira Service Desk Software Cloud Jenkins Integration
     *     (Deployment Gating)}
     */
    public static Localizable _JiraCheckGateStatusStep_DescriptorImpl_DisplayName() {
        return new Localizable(holder, "JiraCheckGateStatusStep.DescriptorImpl.DisplayName");
    }

    /**
     * Key {@code JiraBuildInfoResponse.FAILURE_BUILDS_API_RESPONSE}: {@code
     * Failed to send build information to Jira: {0}. {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to send build information to Jira: {0}. {1}}
     */
    public static String JiraBuildInfoResponse_FAILURE_BUILDS_API_RESPONSE(Object arg0, Object arg1) {
        return holder.format("JiraBuildInfoResponse.FAILURE_BUILDS_API_RESPONSE", arg0, arg1);
    }

    /**
     * Key {@code JiraBuildInfoResponse.FAILURE_BUILDS_API_RESPONSE}: {@code
     * Failed to send build information to Jira: {0}. {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to send build information to Jira: {0}. {1}}
     */
    public static Localizable _JiraBuildInfoResponse_FAILURE_BUILDS_API_RESPONSE(Object arg0, Object arg1) {
        return new Localizable(holder, "JiraBuildInfoResponse.FAILURE_BUILDS_API_RESPONSE", arg0, arg1);
    }

    /**
     * Key {@code JiraBuildInfoResponse.FAILURE_UNKNOWN_ISSUE_KEYS}: {@code
     * Failed to send build information to Jira: {0}. Unknown issue keys:
     * {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to send build information to Jira: {0}. Unknown issue
     *     keys: {1}.}
     */
    public static String JiraBuildInfoResponse_FAILURE_UNKNOWN_ISSUE_KEYS(Object arg0, Object arg1) {
        return holder.format("JiraBuildInfoResponse.FAILURE_UNKNOWN_ISSUE_KEYS", arg0, arg1);
    }

    /**
     * Key {@code JiraBuildInfoResponse.FAILURE_UNKNOWN_ISSUE_KEYS}: {@code
     * Failed to send build information to Jira: {0}. Unknown issue keys:
     * {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to send build information to Jira: {0}. Unknown issue
     *     keys: {1}.}
     */
    public static Localizable _JiraBuildInfoResponse_FAILURE_UNKNOWN_ISSUE_KEYS(Object arg0, Object arg1) {
        return new Localizable(holder, "JiraBuildInfoResponse.FAILURE_UNKNOWN_ISSUE_KEYS", arg0, arg1);
    }

    /**
     * Key {@code JiraDeploymentInfoResponse.FAILURE_DEPLOYMENT_REJECTED}:
     * {@code Failed to send deployment information to Jira: {0}. Rejected
     * deployments: {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to send deployment information to Jira: {0}. Rejected
     *     deployments: {1}.}
     */
    public static String JiraDeploymentInfoResponse_FAILURE_DEPLOYMENT_REJECTED(Object arg0, Object arg1) {
        return holder.format("JiraDeploymentInfoResponse.FAILURE_DEPLOYMENT_REJECTED", arg0, arg1);
    }

    /**
     * Key {@code JiraDeploymentInfoResponse.FAILURE_DEPLOYMENT_REJECTED}:
     * {@code Failed to send deployment information to Jira: {0}. Rejected
     * deployments: {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to send deployment information to Jira: {0}. Rejected
     *     deployments: {1}.}
     */
    public static Localizable _JiraDeploymentInfoResponse_FAILURE_DEPLOYMENT_REJECTED(Object arg0, Object arg1) {
        return new Localizable(holder, "JiraDeploymentInfoResponse.FAILURE_DEPLOYMENT_REJECTED", arg0, arg1);
    }

    /**
     * Key {@code JiraBuildInfoResponse.FAILURE_UNKNOWN_ASSOCIATIONS}: {@code
     * Failed to send build information to Jira: {0}. Unknown associations:
     * {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to send build information to Jira: {0}. Unknown
     *     associations: {1}.}
     */
    public static String JiraBuildInfoResponse_FAILURE_UNKNOWN_ASSOCIATIONS(Object arg0, Object arg1) {
        return holder.format("JiraBuildInfoResponse.FAILURE_UNKNOWN_ASSOCIATIONS", arg0, arg1);
    }

    /**
     * Key {@code JiraBuildInfoResponse.FAILURE_UNKNOWN_ASSOCIATIONS}: {@code
     * Failed to send build information to Jira: {0}. Unknown associations:
     * {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to send build information to Jira: {0}. Unknown
     *     associations: {1}.}
     */
    public static Localizable _JiraBuildInfoResponse_FAILURE_UNKNOWN_ASSOCIATIONS(Object arg0, Object arg1) {
        return new Localizable(holder, "JiraBuildInfoResponse.FAILURE_UNKNOWN_ASSOCIATIONS", arg0, arg1);
    }

    /**
     * Key {@code JiraCommonResponse.FAILURE_NO_SITE_CONFIG_PRESENT}: {@code
     * Could not pick a default site because no site has been configured.}.
     * 
     * @return
     *     {@code Could not pick a default site because no site has been
     *     configured.}
     */
    public static String JiraCommonResponse_FAILURE_NO_SITE_CONFIG_PRESENT() {
        return holder.format("JiraCommonResponse.FAILURE_NO_SITE_CONFIG_PRESENT");
    }

    /**
     * Key {@code JiraCommonResponse.FAILURE_NO_SITE_CONFIG_PRESENT}: {@code
     * Could not pick a default site because no site has been configured.}.
     * 
     * @return
     *     {@code Could not pick a default site because no site has been
     *     configured.}
     */
    public static Localizable _JiraCommonResponse_FAILURE_NO_SITE_CONFIG_PRESENT() {
        return new Localizable(holder, "JiraCommonResponse.FAILURE_NO_SITE_CONFIG_PRESENT");
    }

    /**
     * Key {@code JiraDeploymentInfoResponse.FAILURE_UNEXPECTED_RESPONSE}:
     * {@code Unexpected DeploymentApi response.}.
     * 
     * @return
     *     {@code Unexpected DeploymentApi response.}
     */
    public static String JiraDeploymentInfoResponse_FAILURE_UNEXPECTED_RESPONSE() {
        return holder.format("JiraDeploymentInfoResponse.FAILURE_UNEXPECTED_RESPONSE");
    }

    /**
     * Key {@code JiraDeploymentInfoResponse.FAILURE_UNEXPECTED_RESPONSE}:
     * {@code Unexpected DeploymentApi response.}.
     * 
     * @return
     *     {@code Unexpected DeploymentApi response.}
     */
    public static Localizable _JiraDeploymentInfoResponse_FAILURE_UNEXPECTED_RESPONSE() {
        return new Localizable(holder, "JiraDeploymentInfoResponse.FAILURE_UNEXPECTED_RESPONSE");
    }

    /**
     * Key {@code
     * JiraDeploymentInfoResponse.FAILURE_DEPLOYMENTS_API_RESPONSE}: {@code
     * Failed to send deployment information to Jira: {0}. {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to send deployment information to Jira: {0}. {1}}
     */
    public static String JiraDeploymentInfoResponse_FAILURE_DEPLOYMENTS_API_RESPONSE(Object arg0, Object arg1) {
        return holder.format("JiraDeploymentInfoResponse.FAILURE_DEPLOYMENTS_API_RESPONSE", arg0, arg1);
    }

    /**
     * Key {@code
     * JiraDeploymentInfoResponse.FAILURE_DEPLOYMENTS_API_RESPONSE}: {@code
     * Failed to send deployment information to Jira: {0}. {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to send deployment information to Jira: {0}. {1}}
     */
    public static Localizable _JiraDeploymentInfoResponse_FAILURE_DEPLOYMENTS_API_RESPONSE(Object arg0, Object arg1) {
        return new Localizable(holder, "JiraDeploymentInfoResponse.FAILURE_DEPLOYMENTS_API_RESPONSE", arg0, arg1);
    }

    /**
     * Key {@code JiraDeploymentInfoResponse.SUCCESS_DEPLOYMENT_ACCEPTED}:
     * {@code Successfully sent deployment information to Jira: {0}. Accepted
     * deployments: {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Successfully sent deployment information to Jira: {0}. Accepted
     *     deployments: {1}.}
     */
    public static String JiraDeploymentInfoResponse_SUCCESS_DEPLOYMENT_ACCEPTED(Object arg0, Object arg1) {
        return holder.format("JiraDeploymentInfoResponse.SUCCESS_DEPLOYMENT_ACCEPTED", arg0, arg1);
    }

    /**
     * Key {@code JiraDeploymentInfoResponse.SUCCESS_DEPLOYMENT_ACCEPTED}:
     * {@code Successfully sent deployment information to Jira: {0}. Accepted
     * deployments: {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Successfully sent deployment information to Jira: {0}. Accepted
     *     deployments: {1}.}
     */
    public static Localizable _JiraDeploymentInfoResponse_SUCCESS_DEPLOYMENT_ACCEPTED(Object arg0, Object arg1) {
        return new Localizable(holder, "JiraDeploymentInfoResponse.SUCCESS_DEPLOYMENT_ACCEPTED", arg0, arg1);
    }

    /**
     * Key {@code JiraBuildInfoResponse.SKIPPED_ISSUE_KEYS_NOT_FOUND}: {@code
     * No issue keys found in the current branch name. Not sending build
     * information to Jira.}.
     * 
     * @return
     *     {@code No issue keys found in the current branch name. Not sending
     *     build information to Jira.}
     */
    public static String JiraBuildInfoResponse_SKIPPED_ISSUE_KEYS_NOT_FOUND() {
        return holder.format("JiraBuildInfoResponse.SKIPPED_ISSUE_KEYS_NOT_FOUND");
    }

    /**
     * Key {@code JiraBuildInfoResponse.SKIPPED_ISSUE_KEYS_NOT_FOUND}: {@code
     * No issue keys found in the current branch name. Not sending build
     * information to Jira.}.
     * 
     * @return
     *     {@code No issue keys found in the current branch name. Not sending
     *     build information to Jira.}
     */
    public static Localizable _JiraBuildInfoResponse_SKIPPED_ISSUE_KEYS_NOT_FOUND() {
        return new Localizable(holder, "JiraBuildInfoResponse.SKIPPED_ISSUE_KEYS_NOT_FOUND");
    }

    /**
     * Key {@code JiraSendDeploymentInfoStep.DescriptorImpl.DisplayName}:
     * {@code Atlassian Jira Software Cloud Jenkins Integration
     * (Deployment)}.
     * 
     * @return
     *     {@code Atlassian Jira Software Cloud Jenkins Integration (Deployment)}
     */
    public static String JiraSendDeploymentInfoStep_DescriptorImpl_DisplayName() {
        return holder.format("JiraSendDeploymentInfoStep.DescriptorImpl.DisplayName");
    }

    /**
     * Key {@code JiraSendDeploymentInfoStep.DescriptorImpl.DisplayName}:
     * {@code Atlassian Jira Software Cloud Jenkins Integration
     * (Deployment)}.
     * 
     * @return
     *     {@code Atlassian Jira Software Cloud Jenkins Integration (Deployment)}
     */
    public static Localizable _JiraSendDeploymentInfoStep_DescriptorImpl_DisplayName() {
        return new Localizable(holder, "JiraSendDeploymentInfoStep.DescriptorImpl.DisplayName");
    }

    /**
     * Key {@code JiraCommonResponse.FAILURE_SECRET_NOT_FOUND}: {@code Failed
     * to retrieve credentials for Jira site: {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to retrieve credentials for Jira site: {0}.}
     */
    public static String JiraCommonResponse_FAILURE_SECRET_NOT_FOUND(Object arg0) {
        return holder.format("JiraCommonResponse.FAILURE_SECRET_NOT_FOUND", arg0);
    }

    /**
     * Key {@code JiraCommonResponse.FAILURE_SECRET_NOT_FOUND}: {@code Failed
     * to retrieve credentials for Jira site: {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to retrieve credentials for Jira site: {0}.}
     */
    public static Localizable _JiraCommonResponse_FAILURE_SECRET_NOT_FOUND(Object arg0) {
        return new Localizable(holder, "JiraCommonResponse.FAILURE_SECRET_NOT_FOUND", arg0);
    }

    /**
     * Key {@code JiraSendBuildInfoStep.DescriptorImpl.DisplayName}: {@code
     * Atlassian Jira Software Cloud Jenkins Integration (Build)}.
     * 
     * @return
     *     {@code Atlassian Jira Software Cloud Jenkins Integration (Build)}
     */
    public static String JiraSendBuildInfoStep_DescriptorImpl_DisplayName() {
        return holder.format("JiraSendBuildInfoStep.DescriptorImpl.DisplayName");
    }

    /**
     * Key {@code JiraSendBuildInfoStep.DescriptorImpl.DisplayName}: {@code
     * Atlassian Jira Software Cloud Jenkins Integration (Build)}.
     * 
     * @return
     *     {@code Atlassian Jira Software Cloud Jenkins Integration (Build)}
     */
    public static Localizable _JiraSendBuildInfoStep_DescriptorImpl_DisplayName() {
        return new Localizable(holder, "JiraSendBuildInfoStep.DescriptorImpl.DisplayName");
    }

    /**
     * Key {@code JiraDeploymentInfoResponse.FAILURE_STATE_INVALID}: {@code
     * The deployment state is not valid. {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The deployment state is not valid. {0}}
     */
    public static String JiraDeploymentInfoResponse_FAILURE_STATE_INVALID(Object arg0) {
        return holder.format("JiraDeploymentInfoResponse.FAILURE_STATE_INVALID", arg0);
    }

    /**
     * Key {@code JiraDeploymentInfoResponse.FAILURE_STATE_INVALID}: {@code
     * The deployment state is not valid. {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The deployment state is not valid. {0}}
     */
    public static Localizable _JiraDeploymentInfoResponse_FAILURE_STATE_INVALID(Object arg0) {
        return new Localizable(holder, "JiraDeploymentInfoResponse.FAILURE_STATE_INVALID", arg0);
    }

    /**
     * Key {@code JiraCommonResponse.FAILURE_SITE_CONFIG_NOT_FOUND}: {@code
     * Failed to retrieve configuration for Jira site: {0}. Please specify
     * the site in Jenkinsfile if you have more than one Jira Cloud site
     * configured.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to retrieve configuration for Jira site: {0}. Please
     *     specify the site in Jenkinsfile if you have more than one Jira Cloud
     *     site configured.}
     */
    public static String JiraCommonResponse_FAILURE_SITE_CONFIG_NOT_FOUND(Object arg0) {
        return holder.format("JiraCommonResponse.FAILURE_SITE_CONFIG_NOT_FOUND", arg0);
    }

    /**
     * Key {@code JiraCommonResponse.FAILURE_SITE_CONFIG_NOT_FOUND}: {@code
     * Failed to retrieve configuration for Jira site: {0}. Please specify
     * the site in Jenkinsfile if you have more than one Jira Cloud site
     * configured.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to retrieve configuration for Jira site: {0}. Please
     *     specify the site in Jenkinsfile if you have more than one Jira Cloud
     *     site configured.}
     */
    public static Localizable _JiraCommonResponse_FAILURE_SITE_CONFIG_NOT_FOUND(Object arg0) {
        return new Localizable(holder, "JiraCommonResponse.FAILURE_SITE_CONFIG_NOT_FOUND", arg0);
    }

    /**
     * Key {@code
     * JiraDeploymentInfoResponse.SKIPPED_ISSUE_KEYS_NOT_FOUND_AND_SERVICE_IDS_NOT_PROVIDED}:
     * {@code No issue keys found in the change log and service ids were not
     * provided. Not sending deployment information to Jira: {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No issue keys found in the change log and service ids were not
     *     provided. Not sending deployment information to Jira: {0}.}
     */
    public static String JiraDeploymentInfoResponse_SKIPPED_ISSUE_KEYS_NOT_FOUND_AND_SERVICE_IDS_NOT_PROVIDED(Object arg0) {
        return holder.format("JiraDeploymentInfoResponse.SKIPPED_ISSUE_KEYS_NOT_FOUND_AND_SERVICE_IDS_NOT_PROVIDED", arg0);
    }

    /**
     * Key {@code
     * JiraDeploymentInfoResponse.SKIPPED_ISSUE_KEYS_NOT_FOUND_AND_SERVICE_IDS_NOT_PROVIDED}:
     * {@code No issue keys found in the change log and service ids were not
     * provided. Not sending deployment information to Jira: {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No issue keys found in the change log and service ids were not
     *     provided. Not sending deployment information to Jira: {0}.}
     */
    public static Localizable _JiraDeploymentInfoResponse_SKIPPED_ISSUE_KEYS_NOT_FOUND_AND_SERVICE_IDS_NOT_PROVIDED(Object arg0) {
        return new Localizable(holder, "JiraDeploymentInfoResponse.SKIPPED_ISSUE_KEYS_NOT_FOUND_AND_SERVICE_IDS_NOT_PROVIDED", arg0);
    }

    /**
     * Key {@code JiraBuildInfoResponse.FAILURE_SCM_REVISION_NOT_FOUND}:
     * {@code Failed to retrieve SCM revision for build: {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to retrieve SCM revision for build: {0}.}
     */
    public static String JiraBuildInfoResponse_FAILURE_SCM_REVISION_NOT_FOUND(Object arg0) {
        return holder.format("JiraBuildInfoResponse.FAILURE_SCM_REVISION_NOT_FOUND", arg0);
    }

    /**
     * Key {@code JiraBuildInfoResponse.FAILURE_SCM_REVISION_NOT_FOUND}:
     * {@code Failed to retrieve SCM revision for build: {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to retrieve SCM revision for build: {0}.}
     */
    public static Localizable _JiraBuildInfoResponse_FAILURE_SCM_REVISION_NOT_FOUND(Object arg0) {
        return new Localizable(holder, "JiraBuildInfoResponse.FAILURE_SCM_REVISION_NOT_FOUND", arg0);
    }

    /**
     * Key {@code JiraBuildInfoResponse.FAILURE_UNEXPECTED_RESPONSE}: {@code
     * Unexpected BuildApi response.}.
     * 
     * @return
     *     {@code Unexpected BuildApi response.}
     */
    public static String JiraBuildInfoResponse_FAILURE_UNEXPECTED_RESPONSE() {
        return holder.format("JiraBuildInfoResponse.FAILURE_UNEXPECTED_RESPONSE");
    }

    /**
     * Key {@code JiraBuildInfoResponse.FAILURE_UNEXPECTED_RESPONSE}: {@code
     * Unexpected BuildApi response.}.
     * 
     * @return
     *     {@code Unexpected BuildApi response.}
     */
    public static Localizable _JiraBuildInfoResponse_FAILURE_UNEXPECTED_RESPONSE() {
        return new Localizable(holder, "JiraBuildInfoResponse.FAILURE_UNEXPECTED_RESPONSE");
    }

    /**
     * Key {@code JiraDeploymentInfoResponse.FAILURE_ENVIRONMENT_INVALID}:
     * {@code The deployment environment is not valid. {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The deployment environment is not valid. {0}}
     */
    public static String JiraDeploymentInfoResponse_FAILURE_ENVIRONMENT_INVALID(Object arg0) {
        return holder.format("JiraDeploymentInfoResponse.FAILURE_ENVIRONMENT_INVALID", arg0);
    }

    /**
     * Key {@code JiraDeploymentInfoResponse.FAILURE_ENVIRONMENT_INVALID}:
     * {@code The deployment environment is not valid. {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The deployment environment is not valid. {0}}
     */
    public static Localizable _JiraDeploymentInfoResponse_FAILURE_ENVIRONMENT_INVALID(Object arg0) {
        return new Localizable(holder, "JiraDeploymentInfoResponse.FAILURE_ENVIRONMENT_INVALID", arg0);
    }

    /**
     * Key {@code JiraCommonResponse.FAILURE_ACCESS_TOKEN}: {@code Failed to
     * get access token for Jira site: {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to get access token for Jira site: {0}.}
     */
    public static String JiraCommonResponse_FAILURE_ACCESS_TOKEN(Object arg0) {
        return holder.format("JiraCommonResponse.FAILURE_ACCESS_TOKEN", arg0);
    }

    /**
     * Key {@code JiraCommonResponse.FAILURE_ACCESS_TOKEN}: {@code Failed to
     * get access token for Jira site: {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to get access token for Jira site: {0}.}
     */
    public static Localizable _JiraCommonResponse_FAILURE_ACCESS_TOKEN(Object arg0) {
        return new Localizable(holder, "JiraCommonResponse.FAILURE_ACCESS_TOKEN", arg0);
    }

    /**
     * Key {@code JiraGateStatusResponse.GATE_CHECK_SUCCESS}: {@code
     * Successfully retrieved deployment gating status. Related issues: {0},
     * gating status: {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Successfully retrieved deployment gating status. Related
     *     issues: {0}, gating status: {1}.}
     */
    public static String JiraGateStatusResponse_GATE_CHECK_SUCCESS(Object arg0, Object arg1) {
        return holder.format("JiraGateStatusResponse.GATE_CHECK_SUCCESS", arg0, arg1);
    }

    /**
     * Key {@code JiraGateStatusResponse.GATE_CHECK_SUCCESS}: {@code
     * Successfully retrieved deployment gating status. Related issues: {0},
     * gating status: {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Successfully retrieved deployment gating status. Related
     *     issues: {0}, gating status: {1}.}
     */
    public static Localizable _JiraGateStatusResponse_GATE_CHECK_SUCCESS(Object arg0, Object arg1) {
        return new Localizable(holder, "JiraGateStatusResponse.GATE_CHECK_SUCCESS", arg0, arg1);
    }

    /**
     * Key {@code JiraBuildInfoResponse.FAILURE_BUILD_REJECTED}: {@code
     * Failed to send build information to Jira: {0}. Rejected builds: {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to send build information to Jira: {0}. Rejected builds:
     *     {1}.}
     */
    public static String JiraBuildInfoResponse_FAILURE_BUILD_REJECTED(Object arg0, Object arg1) {
        return holder.format("JiraBuildInfoResponse.FAILURE_BUILD_REJECTED", arg0, arg1);
    }

    /**
     * Key {@code JiraBuildInfoResponse.FAILURE_BUILD_REJECTED}: {@code
     * Failed to send build information to Jira: {0}. Rejected builds: {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to send build information to Jira: {0}. Rejected builds:
     *     {1}.}
     */
    public static Localizable _JiraBuildInfoResponse_FAILURE_BUILD_REJECTED(Object arg0, Object arg1) {
        return new Localizable(holder, "JiraBuildInfoResponse.FAILURE_BUILD_REJECTED", arg0, arg1);
    }

    /**
     * Key {@code JiraCheckGateStatusStep.CauseOfInterruption.Description}:
     * {@code The deployment was prevented by Jira Service Desk.}.
     * 
     * @return
     *     {@code The deployment was prevented by Jira Service Desk.}
     */
    public static String JiraCheckGateStatusStep_CauseOfInterruption_Description() {
        return holder.format("JiraCheckGateStatusStep.CauseOfInterruption.Description");
    }

    /**
     * Key {@code JiraCheckGateStatusStep.CauseOfInterruption.Description}:
     * {@code The deployment was prevented by Jira Service Desk.}.
     * 
     * @return
     *     {@code The deployment was prevented by Jira Service Desk.}
     */
    public static Localizable _JiraCheckGateStatusStep_CauseOfInterruption_Description() {
        return new Localizable(holder, "JiraCheckGateStatusStep.CauseOfInterruption.Description");
    }

    /**
     * Key {@code JiraCommonResponse.FAILURE_MULTIPLE_SITE_CONFIGS_PRESENT}:
     * {@code Could not pick a default site because multiple sites have been
     * configured.}.
     * 
     * @return
     *     {@code Could not pick a default site because multiple sites have been
     *     configured.}
     */
    public static String JiraCommonResponse_FAILURE_MULTIPLE_SITE_CONFIGS_PRESENT() {
        return holder.format("JiraCommonResponse.FAILURE_MULTIPLE_SITE_CONFIGS_PRESENT");
    }

    /**
     * Key {@code JiraCommonResponse.FAILURE_MULTIPLE_SITE_CONFIGS_PRESENT}:
     * {@code Could not pick a default site because multiple sites have been
     * configured.}.
     * 
     * @return
     *     {@code Could not pick a default site because multiple sites have been
     *     configured.}
     */
    public static Localizable _JiraCommonResponse_FAILURE_MULTIPLE_SITE_CONFIGS_PRESENT() {
        return new Localizable(holder, "JiraCommonResponse.FAILURE_MULTIPLE_SITE_CONFIGS_PRESENT");
    }

    /**
     * Key {@code JiraCommonResponse.FAILURE_SITE_NOT_FOUND}: {@code Jira
     * site: {0} can't be found.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Jira site: {0} can't be found.}
     */
    public static String JiraCommonResponse_FAILURE_SITE_NOT_FOUND(Object arg0) {
        return holder.format("JiraCommonResponse.FAILURE_SITE_NOT_FOUND", arg0);
    }

    /**
     * Key {@code JiraCommonResponse.FAILURE_SITE_NOT_FOUND}: {@code Jira
     * site: {0} can't be found.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Jira site: {0} can't be found.}
     */
    public static Localizable _JiraCommonResponse_FAILURE_SITE_NOT_FOUND(Object arg0) {
        return new Localizable(holder, "JiraCommonResponse.FAILURE_SITE_NOT_FOUND", arg0);
    }

    /**
     * Key {@code JiraDeploymentInfoResponse.FAILURE_UNKNOWN_ASSOCIATIONS}:
     * {@code Failed to send deployment information to Jira: {0}. Unknown
     * associations: {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to send deployment information to Jira: {0}. Unknown
     *     associations: {1}.}
     */
    public static String JiraDeploymentInfoResponse_FAILURE_UNKNOWN_ASSOCIATIONS(Object arg0, Object arg1) {
        return holder.format("JiraDeploymentInfoResponse.FAILURE_UNKNOWN_ASSOCIATIONS", arg0, arg1);
    }

    /**
     * Key {@code JiraDeploymentInfoResponse.FAILURE_UNKNOWN_ASSOCIATIONS}:
     * {@code Failed to send deployment information to Jira: {0}. Unknown
     * associations: {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to send deployment information to Jira: {0}. Unknown
     *     associations: {1}.}
     */
    public static Localizable _JiraDeploymentInfoResponse_FAILURE_UNKNOWN_ASSOCIATIONS(Object arg0, Object arg1) {
        return new Localizable(holder, "JiraDeploymentInfoResponse.FAILURE_UNKNOWN_ASSOCIATIONS", arg0, arg1);
    }

}
