/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cloud.jenkins.util;

import com.atlassian.jira.cloud.jenkins.common.model.IssueKey;
import com.atlassian.jira.cloud.jenkins.common.service.IssueKeyExtractor;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public final class IssueKeyStringExtractor {
    private static final String SEPARATOR = "[\\s\\p{Punct}]";
    private static final String KEY_PREFIX_REGEX = "(?:(?<=[\\s\\p{Punct}])|^)";
    private static final String KEY_BODY_REGEX = "(\\p{Lu}[\\p{Lu}\\p{Digit}_]{1,255}-\\p{Digit}{1,100})";
    private static final String KEY_POSTFIX_REGEX = "(?:(?=[\\s\\p{Punct}])|$)";
    private static final String ISSUE_KEY_REGEX = "(?:(?<=[\\s\\p{Punct}])|^)(\\p{Lu}[\\p{Lu}\\p{Digit}_]{1,255}-\\p{Digit}{1,100})(?:(?=[\\s\\p{Punct}])|$)";
    private static final Pattern PROJECT_KEY_PATTERN = Pattern.compile("(?:(?<=[\\s\\p{Punct}])|^)(\\p{Lu}[\\p{Lu}\\p{Digit}_]{1,255}-\\p{Digit}{1,100})(?:(?=[\\s\\p{Punct}])|$)");

    private IssueKeyStringExtractor() {
    }

    public static Set<IssueKey> extractIssueKeys(String text) {
        HashSet<IssueKey> matches = new HashSet<IssueKey>();
        if (StringUtils.isBlank((String)text)) {
            return Collections.emptySet();
        }
        Matcher match = PROJECT_KEY_PATTERN.matcher(text);
        while (match.find()) {
            for (int i = 1; i <= match.groupCount(); ++i) {
                String issueKey = match.group(i);
                matches.add(new IssueKey(issueKey));
                if (matches.size() < IssueKeyExtractor.ISSUE_KEY_MAX_LIMIT) continue;
                return ImmutableSet.copyOf(matches);
            }
        }
        return ImmutableSet.copyOf(matches);
    }
}

