/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cloud.jenkins.provider;

import com.google.inject.Provides;
import java.io.IOException;
import java.time.Duration;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientProvider {
    private static final String USER_AGENT = "atlassian-jira-software-cloud-plugin";
    private static final Logger log = LoggerFactory.getLogger(HttpClientProvider.class);
    private final OkHttpClient httpClient = new OkHttpClient.Builder().connectTimeout(Duration.ofMillis(5000L)).readTimeout(Duration.ofMillis(5000L)).writeTimeout(Duration.ofMillis(5000L)).addInterceptor(this.userAgentInterceptor()).addInterceptor(this.retryInterceptor()).build();

    private Interceptor retryInterceptor() {
        return chain -> {
            Request request = chain.request();
            Response response = chain.proceed(request);
            response = this.performRetry(chain, request, response);
            return response;
        };
    }

    private Interceptor userAgentInterceptor() {
        return chain -> {
            Request originalRequest = chain.request();
            Request userAgentRequest = originalRequest.newBuilder().header("User-Agent", USER_AGENT).build();
            return chain.proceed(userAgentRequest);
        };
    }

    private Response performRetry(Interceptor.Chain chain, Request request, Response originalResponse) throws IOException {
        Response response = originalResponse;
        int MAX_RETRIES = 3;
        for (int currentAttempt = 1; response.code() >= 500 && currentAttempt <= 3; ++currentAttempt) {
            log.warn(String.format("Received %d for request to %s. Retry attempt %d of %d.", response.code(), response.request().url(), currentAttempt, 3));
            response.close();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                log.error("Retry delay interrupted: " + e.getMessage());
                Thread.currentThread().interrupt();
            }
            response = chain.proceed(request);
        }
        return response;
    }

    @Provides
    public OkHttpClient httpClient() {
        return this.httpClient;
    }
}

