/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cloud.jenkins.deploymentinfo.service;

import com.atlassian.jira.cloud.jenkins.auth.AccessTokenRetriever;
import com.atlassian.jira.cloud.jenkins.common.client.JiraApi;
import com.atlassian.jira.cloud.jenkins.common.client.PostUpdateResult;
import com.atlassian.jira.cloud.jenkins.common.config.JiraSiteConfigRetriever;
import com.atlassian.jira.cloud.jenkins.common.model.AppCredential;
import com.atlassian.jira.cloud.jenkins.common.response.JiraCommonResponse;
import com.atlassian.jira.cloud.jenkins.common.response.JiraSendInfoResponse;
import com.atlassian.jira.cloud.jenkins.common.service.IssueKeyExtractor;
import com.atlassian.jira.cloud.jenkins.config.JiraCloudSiteConfig;
import com.atlassian.jira.cloud.jenkins.deploymentinfo.client.DeploymentPayloadBuilder;
import com.atlassian.jira.cloud.jenkins.deploymentinfo.client.model.DeploymentApiResponse;
import com.atlassian.jira.cloud.jenkins.deploymentinfo.client.model.Deployments;
import com.atlassian.jira.cloud.jenkins.deploymentinfo.client.model.Environment;
import com.atlassian.jira.cloud.jenkins.deploymentinfo.service.EnvironmentValidator;
import com.atlassian.jira.cloud.jenkins.deploymentinfo.service.JiraDeploymentInfoRequest;
import com.atlassian.jira.cloud.jenkins.deploymentinfo.service.JiraDeploymentInfoResponse;
import com.atlassian.jira.cloud.jenkins.deploymentinfo.service.JiraDeploymentInfoSender;
import com.atlassian.jira.cloud.jenkins.tenantinfo.CloudIdResolver;
import com.atlassian.jira.cloud.jenkins.util.RunWrapperProvider;
import com.atlassian.jira.cloud.jenkins.util.SecretRetriever;
import hudson.model.Run;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.support.steps.build.RunWrapper;

public class JiraDeploymentInfoSenderImpl
implements JiraDeploymentInfoSender {
    private static final String HTTPS_PROTOCOL = "https://";
    private final JiraSiteConfigRetriever siteConfigRetriever;
    private final SecretRetriever secretRetriever;
    private final CloudIdResolver cloudIdResolver;
    private final AccessTokenRetriever accessTokenRetriever;
    private final JiraApi deploymentsApi;
    private final RunWrapperProvider runWrapperProvider;
    private final IssueKeyExtractor issueKeyExtractor;

    public JiraDeploymentInfoSenderImpl(JiraSiteConfigRetriever siteConfigRetriever, SecretRetriever secretRetriever, CloudIdResolver cloudIdResolver, AccessTokenRetriever accessTokenRetriever, JiraApi jiraApi, IssueKeyExtractor issueKeyExtractor, RunWrapperProvider runWrapperProvider) {
        this.siteConfigRetriever = Objects.requireNonNull(siteConfigRetriever);
        this.secretRetriever = Objects.requireNonNull(secretRetriever);
        this.cloudIdResolver = Objects.requireNonNull(cloudIdResolver);
        this.accessTokenRetriever = Objects.requireNonNull(accessTokenRetriever);
        this.deploymentsApi = Objects.requireNonNull(jiraApi);
        this.runWrapperProvider = Objects.requireNonNull(runWrapperProvider);
        this.issueKeyExtractor = Objects.requireNonNull(issueKeyExtractor);
    }

    @Override
    public JiraSendInfoResponse sendDeploymentInfo(JiraDeploymentInfoRequest request) {
        String jiraSite = request.getSite();
        WorkflowRun deployment = request.getDeployment();
        Optional<JiraCloudSiteConfig> maybeSiteConfig = this.getSiteConfigFor(jiraSite);
        if (!maybeSiteConfig.isPresent()) {
            return JiraCommonResponse.failureSiteConfigNotFound(jiraSite);
        }
        String resolvedSiteConfig = maybeSiteConfig.get().getSite();
        JiraCloudSiteConfig siteConfig = maybeSiteConfig.get();
        Optional<String> maybeSecret = this.getSecretFor(siteConfig.getCredentialsId());
        if (!maybeSecret.isPresent()) {
            return JiraCommonResponse.failureSecretNotFound(resolvedSiteConfig);
        }
        Environment environment = this.buildEnvironment(request);
        List<String> errorMessages = EnvironmentValidator.validate(environment);
        if (!errorMessages.isEmpty()) {
            return JiraDeploymentInfoResponse.failureEnvironmentInvalid(jiraSite, errorMessages);
        }
        Set<String> issueKeys = this.issueKeyExtractor.extractIssueKeys(deployment);
        if (issueKeys.isEmpty()) {
            return JiraDeploymentInfoResponse.skippedIssueKeysNotFound(resolvedSiteConfig);
        }
        Optional<String> maybeCloudId = this.getCloudIdFor(resolvedSiteConfig);
        if (!maybeCloudId.isPresent()) {
            return JiraCommonResponse.failureSiteNotFound(resolvedSiteConfig);
        }
        Optional<String> maybeAccessToken = this.getAccessTokenFor(siteConfig, maybeSecret.get());
        if (!maybeAccessToken.isPresent()) {
            return JiraCommonResponse.failureAccessToken(resolvedSiteConfig);
        }
        Deployments deploymentInfo = this.createJiraDeploymentInfo((Run)deployment, environment, issueKeys);
        PostUpdateResult<DeploymentApiResponse> postUpdateResult = this.sendDeploymentInfo(maybeCloudId.get(), maybeAccessToken.get(), resolvedSiteConfig, deploymentInfo);
        if (postUpdateResult.getResponseEntity().isPresent()) {
            return this.handleDeploymentApiResponse(resolvedSiteConfig, postUpdateResult.getResponseEntity().get());
        }
        String errorMessage = postUpdateResult.getErrorMessage().orElse("");
        return this.handleDeploymentApiError(resolvedSiteConfig, errorMessage);
    }

    private Optional<JiraCloudSiteConfig> getSiteConfigFor(@Nullable String jiraSite) {
        return this.siteConfigRetriever.getJiraSiteConfig(jiraSite);
    }

    private Optional<String> getCloudIdFor(String jiraSite) {
        String jiraSiteUrl = HTTPS_PROTOCOL + jiraSite;
        return this.cloudIdResolver.getCloudId(jiraSiteUrl);
    }

    private Optional<String> getAccessTokenFor(JiraCloudSiteConfig siteConfig, String secret) {
        AppCredential appCredential = new AppCredential(siteConfig.getClientId(), secret);
        return this.accessTokenRetriever.getAccessToken(appCredential);
    }

    private Optional<String> getSecretFor(String credentialsId) {
        return this.secretRetriever.getSecretFor(credentialsId);
    }

    private Deployments createJiraDeploymentInfo(Run build, Environment environment, Set<String> issueKeys) {
        RunWrapper buildWrapper = this.runWrapperProvider.getWrapper(build);
        return DeploymentPayloadBuilder.getDeploymentInfo(buildWrapper, environment, issueKeys);
    }

    private PostUpdateResult<DeploymentApiResponse> sendDeploymentInfo(String cloudId, String accessToken, String jiraSite, Deployments deploymentInfo) {
        return this.deploymentsApi.postUpdate(cloudId, accessToken, jiraSite, deploymentInfo, DeploymentApiResponse.class);
    }

    private JiraSendInfoResponse handleDeploymentApiResponse(String jiraSite, DeploymentApiResponse response) {
        if (!response.getAcceptedDeployments().isEmpty()) {
            return JiraDeploymentInfoResponse.successDeploymentAccepted(jiraSite, response);
        }
        if (!response.getRejectedDeployments().isEmpty()) {
            return JiraDeploymentInfoResponse.failureDeploymentdRejected(jiraSite, response);
        }
        if (!response.getUnknownIssueKeys().isEmpty()) {
            return JiraDeploymentInfoResponse.failureUnknownIssueKeys(jiraSite, response);
        }
        return JiraDeploymentInfoResponse.failureUnexpectedResponse();
    }

    private JiraDeploymentInfoResponse handleDeploymentApiError(String jiraSite, String errorMessage) {
        return JiraDeploymentInfoResponse.failureDeploymentsApiResponse(jiraSite, errorMessage);
    }

    private Environment buildEnvironment(JiraDeploymentInfoRequest request) {
        String environmentType = StringUtils.isNotBlank((String)request.getEnvironmentType()) ? request.getEnvironmentType() : "unmapped";
        return Environment.builder().withId(request.getEnvironmentId()).withDisplayName(request.getEnvironmentName()).withType(environmentType).build();
    }
}

