/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cloud.jenkins.deploymentinfo.service;

import com.atlassian.jira.cloud.jenkins.Messages;
import com.atlassian.jira.cloud.jenkins.common.response.JiraSendInfoResponse;
import com.atlassian.jira.cloud.jenkins.deploymentinfo.client.model.DeploymentApiResponse;
import java.util.List;

public class JiraDeploymentInfoResponse
extends JiraSendInfoResponse {
    public JiraDeploymentInfoResponse(JiraSendInfoResponse.Status status, String message) {
        super(status, message);
    }

    public static JiraSendInfoResponse failureEnvironmentInvalid(String jiraSite, List<String> errorMessages) {
        String message = Messages.JiraDeploymentInfoResponse_FAILURE_ENVIRONMENT_INVALID(String.join((CharSequence)" ", errorMessages));
        return new JiraDeploymentInfoResponse(JiraSendInfoResponse.Status.FAILURE_ENVIRONMENT_INVALID, message);
    }

    public static JiraSendInfoResponse skippedIssueKeysNotFound(String jiraSite) {
        String message = Messages.JiraDeploymentInfoResponse_SKIPPED_ISSUE_KEYS_NOT_FOUND(jiraSite);
        return new JiraDeploymentInfoResponse(JiraSendInfoResponse.Status.SKIPPED_ISSUE_KEYS_NOT_FOUND, message);
    }

    public static JiraDeploymentInfoResponse successDeploymentAccepted(String jiraSite, DeploymentApiResponse response) {
        String message = Messages.JiraDeploymentInfoResponse_SUCCESS_DEPLOYMENT_ACCEPTED(jiraSite, response.getAcceptedDeployments());
        return new JiraDeploymentInfoResponse(JiraSendInfoResponse.Status.SUCCESS_DEPLOYMENT_ACCEPTED, message);
    }

    public static JiraDeploymentInfoResponse failureDeploymentdRejected(String jiraSite, DeploymentApiResponse response) {
        String message = Messages.JiraDeploymentInfoResponse_FAILURE_DEPLOYMENT_REJECTED(jiraSite, response.getRejectedDeployments());
        return new JiraDeploymentInfoResponse(JiraSendInfoResponse.Status.FAILURE_DEPLOYMENT_REJECTED, message);
    }

    public static JiraDeploymentInfoResponse failureUnknownIssueKeys(String jiraSite, DeploymentApiResponse response) {
        String message = Messages.JiraDeploymentInfoResponse_FAILURE_UNKNOWN_ISSUE_KEYS(jiraSite, response.getUnknownIssueKeys());
        return new JiraDeploymentInfoResponse(JiraSendInfoResponse.Status.FAILURE_UNKNOWN_ISSUE_KEYS, message);
    }

    public static JiraDeploymentInfoResponse failureUnexpectedResponse() {
        String message = Messages.JiraDeploymentInfoResponse_FAILURE_UNEXPECTED_RESPONSE();
        return new JiraDeploymentInfoResponse(JiraSendInfoResponse.Status.FAILURE_UNEXPECTED_RESPONSE, message);
    }

    public static JiraDeploymentInfoResponse failureDeploymentsApiResponse(String jiraSite, String errorMessage) {
        String message = Messages.JiraDeploymentInfoResponse_FAILURE_DEPLOYMENTS_API_RESPONSE(jiraSite, errorMessage);
        return new JiraDeploymentInfoResponse(JiraSendInfoResponse.Status.FAILURE_DEPLOYMENTS_API_RESPONSE, message);
    }
}

