/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cloud.jenkins.deploymentinfo.service;

import com.atlassian.jira.cloud.jenkins.deploymentinfo.client.model.Environment;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public final class EnvironmentValidator {
    private static final Set<String> ALLOWED_ENVS = ImmutableSet.of((Object)"development", (Object)"testing", (Object)"staging", (Object)"production", (Object)"unmapped");

    public static List<String> validate(Environment environment) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (StringUtils.isBlank((String)environment.getId())) {
            errorMessages.add("The parameter environmentId is required.");
        }
        if (StringUtils.isBlank((String)environment.getDisplayName())) {
            errorMessages.add("The parameter environmentName is required.");
        }
        if (!EnvironmentValidator.isAllowedEnvironmentType(environment.getType())) {
            errorMessages.add("The parameter environmentType is not valid. Allowed values are: " + ALLOWED_ENVS);
        }
        return errorMessages;
    }

    private static boolean isAllowedEnvironmentType(String environmentTyp) {
        return StringUtils.isNotBlank((String)environmentTyp) && ALLOWED_ENVS.contains(environmentTyp);
    }
}

