/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cloud.jenkins.deploymentinfo.service;

import com.atlassian.jira.cloud.jenkins.common.model.IssueKey;
import com.atlassian.jira.cloud.jenkins.common.service.IssueKeyExtractor;
import com.atlassian.jira.cloud.jenkins.util.IssueKeyStringExtractor;
import hudson.plugins.git.GitChangeSet;
import hudson.scm.ChangeLogSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

public final class ChangeLogIssueKeyExtractor
implements IssueKeyExtractor {
    @Override
    public Set<String> extractIssueKeys(WorkflowRun workflowRun) {
        HashSet<IssueKey> allIssueKeys = new HashSet<IssueKey>();
        List changeSets = workflowRun.getChangeSets();
        block0: for (ChangeLogSet changeSet : changeSets) {
            Object[] changeSetEntries;
            for (Object item : changeSetEntries = changeSet.getItems()) {
                ChangeLogSet.Entry changeSetEntry = (ChangeLogSet.Entry)item;
                if (changeSetEntry instanceof GitChangeSet) {
                    allIssueKeys.addAll(IssueKeyStringExtractor.extractIssueKeys(((GitChangeSet)changeSetEntry).getComment()));
                }
                allIssueKeys.addAll(IssueKeyStringExtractor.extractIssueKeys(changeSetEntry.getMsg()));
                if (allIssueKeys.size() >= ISSUE_KEY_MAX_LIMIT) continue block0;
            }
        }
        return allIssueKeys.stream().limit(ISSUE_KEY_MAX_LIMIT.intValue()).map(IssueKey::toString).collect(Collectors.toSet());
    }
}

