/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cloud.jenkins.deploymentinfo.client.model;

import com.atlassian.jira.cloud.jenkins.deploymentinfo.client.model.Environment;
import com.atlassian.jira.cloud.jenkins.deploymentinfo.client.model.Pipeline;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public final class JiraDeploymentInfo {
    private static final String SCHEMA_VERSION = "1.0";
    private final Integer deploymentSequenceNumber;
    private final Long updateSequenceNumber;
    private final Set<String> issueKeys;
    private final String displayName;
    private final String url;
    private final String description;
    private final String lastUpdated;
    private final String label;
    private final String state;
    private final Pipeline pipeline;
    private final Environment environment;

    @JsonCreator
    public JiraDeploymentInfo(@JsonProperty(value="deploymentSequenceNumber") Integer deploymentSequenceNumber, @JsonProperty(value="updateSequenceNumber") Long updateSequenceNumber, @JsonProperty(value="issueKeys") Set<String> issueKeys, @JsonProperty(value="displayName") String displayName, @JsonProperty(value="url") String url, @JsonProperty(value="description") String description, @JsonProperty(value="lastUpdated") String lastUpdated, @JsonProperty(value="label") String label, @JsonProperty(value="state") String state, @JsonProperty(value="pipeline") Pipeline pipeline, @JsonProperty(value="environment") Environment environment) {
        this.deploymentSequenceNumber = deploymentSequenceNumber;
        this.updateSequenceNumber = updateSequenceNumber;
        this.issueKeys = issueKeys;
        this.displayName = displayName;
        this.url = url;
        this.description = description;
        this.lastUpdated = lastUpdated;
        this.label = label;
        this.state = state;
        this.pipeline = pipeline;
        this.environment = environment;
    }

    public Integer getDeploymentSequenceNumber() {
        return this.deploymentSequenceNumber;
    }

    public Long getUpdateSequenceNumber() {
        return this.updateSequenceNumber;
    }

    public Set<String> getIssueKeys() {
        return this.issueKeys;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLastUpdated() {
        return this.lastUpdated;
    }

    public String getLabel() {
        return this.label;
    }

    public String getState() {
        return this.state;
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public String getSchemaVersion() {
        return SCHEMA_VERSION;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Integer deploymentSequenceNumber;
        private Long updateSequenceNumber;
        private Set<String> issueKeys;
        private String displayName;
        private String url;
        private String description;
        private String lastUpdated;
        private String label;
        private String state;
        private Pipeline pipeline;
        private Environment environment;

        public Builder withDeploymentSequenceNumber(Integer deploymentSequenceNumber) {
            this.deploymentSequenceNumber = deploymentSequenceNumber;
            return this;
        }

        public Builder withUpdateSequenceNumber(Long updateSequenceNumber) {
            this.updateSequenceNumber = updateSequenceNumber;
            return this;
        }

        public Builder withIssueKeys(Set<String> issueKeys) {
            this.issueKeys = ImmutableSet.copyOf(issueKeys);
            return this;
        }

        public Builder withDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withLastUpdated(String lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public Builder withLabel(String label) {
            this.label = label;
            return this;
        }

        public Builder withState(String state) {
            this.state = state;
            return this;
        }

        public Builder withPipeline(Pipeline pipeline) {
            this.pipeline = pipeline;
            return this;
        }

        public Builder withEnvironment(Environment environment) {
            this.environment = environment;
            return this;
        }

        public JiraDeploymentInfo build() {
            return new JiraDeploymentInfo(this.deploymentSequenceNumber, this.updateSequenceNumber, this.issueKeys, this.displayName, this.url, this.description, this.lastUpdated, this.label, this.state, this.pipeline, this.environment);
        }
    }
}

