/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cloud.jenkins.common.factory;

import com.atlassian.jira.cloud.jenkins.auth.AccessTokenRetriever;
import com.atlassian.jira.cloud.jenkins.buildinfo.service.JiraBuildInfoSender;
import com.atlassian.jira.cloud.jenkins.buildinfo.service.JiraBuildInfoSenderImpl;
import com.atlassian.jira.cloud.jenkins.common.client.JiraApi;
import com.atlassian.jira.cloud.jenkins.common.config.JiraSiteConfigRetrieverImpl;
import com.atlassian.jira.cloud.jenkins.deploymentinfo.service.ChangeLogIssueKeyExtractor;
import com.atlassian.jira.cloud.jenkins.deploymentinfo.service.JiraDeploymentInfoSender;
import com.atlassian.jira.cloud.jenkins.deploymentinfo.service.JiraDeploymentInfoSenderImpl;
import com.atlassian.jira.cloud.jenkins.provider.HttpClientProvider;
import com.atlassian.jira.cloud.jenkins.provider.ObjectMapperProvider;
import com.atlassian.jira.cloud.jenkins.tenantinfo.CloudIdResolver;
import com.atlassian.jira.cloud.jenkins.util.BranchNameIssueKeyExtractor;
import com.atlassian.jira.cloud.jenkins.util.RunWrapperProviderImpl;
import com.atlassian.jira.cloud.jenkins.util.SecretRetriever;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import okhttp3.OkHttpClient;

public final class JiraSenderFactory {
    private static JiraSenderFactory INSTANCE;
    private JiraBuildInfoSender jiraBuildInfoSender;
    private JiraDeploymentInfoSender jiraDeploymentInfoSender;

    private JiraSenderFactory() {
        ObjectMapperProvider objectMapperProvider = new ObjectMapperProvider();
        HttpClientProvider httpClientProvider = new HttpClientProvider();
        OkHttpClient httpClient = httpClientProvider.httpClient();
        ObjectMapper objectMapper = objectMapperProvider.objectMapper();
        JiraSiteConfigRetrieverImpl siteConfigRetriever = new JiraSiteConfigRetrieverImpl();
        BranchNameIssueKeyExtractor branchNameIssueKeyExtractor = new BranchNameIssueKeyExtractor();
        ChangeLogIssueKeyExtractor changeLogIssueKeyExtractor = new ChangeLogIssueKeyExtractor();
        SecretRetriever secretRetriever = new SecretRetriever();
        CloudIdResolver cloudIdResolver = new CloudIdResolver(httpClient, objectMapper);
        AccessTokenRetriever accessTokenRetriever = new AccessTokenRetriever(httpClient, objectMapper);
        JiraApi buildsApi = new JiraApi(httpClient, objectMapper, "https://api.atlassian.com/jira/builds/0.1/cloud/%s/bulk");
        JiraApi deploymentsApi = new JiraApi(httpClient, objectMapper, "https://api.atlassian.com/jira/deployments/0.1/cloud/%s/bulk");
        this.jiraBuildInfoSender = new JiraBuildInfoSenderImpl(siteConfigRetriever, secretRetriever, branchNameIssueKeyExtractor, cloudIdResolver, accessTokenRetriever, buildsApi, new RunWrapperProviderImpl());
        this.jiraDeploymentInfoSender = new JiraDeploymentInfoSenderImpl(siteConfigRetriever, secretRetriever, cloudIdResolver, accessTokenRetriever, deploymentsApi, changeLogIssueKeyExtractor, new RunWrapperProviderImpl());
    }

    public static synchronized JiraSenderFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JiraSenderFactory();
        }
        return INSTANCE;
    }

    @VisibleForTesting
    public static void setInstance(JiraSenderFactory instance) {
        INSTANCE = instance;
    }

    public JiraBuildInfoSender getJiraBuildInfoSender() {
        return this.jiraBuildInfoSender;
    }

    public JiraDeploymentInfoSender getJiraDeploymentInfoSender() {
        return this.jiraDeploymentInfoSender;
    }
}

